/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.algorithm.annotation;

import java.lang.reflect.AccessibleObject;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.n52.javaps.algorithm.annotation.AbstractOutputAnnotationParser;
import org.n52.javaps.algorithm.annotation.AbstractOutputBinding;
import org.n52.javaps.algorithm.annotation.ComplexOutput;
import org.n52.javaps.description.TypedComplexOutputDescription;
import org.n52.javaps.description.impl.TypedComplexOutputDescriptionImpl;
import org.n52.javaps.description.impl.TypedProcessDescriptionFactory;
import org.n52.javaps.io.OutputHandlerRepository;
import org.n52.javaps.io.complex.ComplexData;
import org.n52.shetland.ogc.wps.Format;

class ComplexOutputAnnotationParser<M extends AccessibleObject, B extends AbstractOutputBinding<M>>
extends AbstractOutputAnnotationParser<ComplexOutput, M, B> {
    private final OutputHandlerRepository generatorRepository;

    ComplexOutputAnnotationParser(Function<M, B> bindingFunction, OutputHandlerRepository generatorRepository) {
        super(bindingFunction);
        this.generatorRepository = Objects.requireNonNull(generatorRepository);
    }

    @Override
    protected TypedComplexOutputDescription createDescription(ComplexOutput annotation, B binding) {
        Class<? extends ComplexData<?>> bindingClass = annotation.binding();
        Set<Format> supportedFormats = this.generatorRepository.getSupportedFormats(bindingClass);
        Format defaultFormat = this.generatorRepository.getDefaultFormat(bindingClass).orElse(null);
        return ((TypedComplexOutputDescriptionImpl.Builder)((TypedComplexOutputDescriptionImpl.Builder)((TypedComplexOutputDescriptionImpl.Builder)((TypedComplexOutputDescriptionImpl.Builder)((TypedComplexOutputDescriptionImpl.Builder)((TypedComplexOutputDescriptionImpl.Builder)new TypedProcessDescriptionFactory().complexOutput().withType(bindingClass)).withDefaultFormat(defaultFormat)).withSupportedFormat(supportedFormats)).withIdentifier(annotation.identifier())).withAbstract(annotation.abstrakt())).withTitle(annotation.title())).build();
    }

    @Override
    public Class<? extends ComplexOutput> getSupportedAnnotation() {
        return ComplexOutput.class;
    }
}

