/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.algorithm.annotation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.n52.javaps.algorithm.annotation.AnnotationBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExecuteBinding
extends AnnotationBinding<Method> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteBinding.class);

    ExecuteBinding(Method method) {
        super(method);
    }

    @Override
    public boolean validate() {
        if (!this.checkModifier()) {
            LOGGER.error("Method {} with Execute annotation can't be used, not public.", this.getMember());
            return false;
        }
        if (!((Method)this.getMember()).getReturnType().equals(Void.TYPE)) {
            LOGGER.error("Method {} with Execute annotation can't be used, return type not void", this.getMember());
            return false;
        }
        if (((Method)this.getMember()).getParameterTypes().length != 0) {
            LOGGER.error("Method {} with Execute annotation can't be used, method parameter count is > 0.", this.getMember());
            return false;
        }
        return true;
    }

    public void execute(Object annotatedInstance) {
        try {
            ((Method)this.getMember()).invoke(annotatedInstance, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new RuntimeException("Internal error executing process", ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause() == null ? ex : ex.getCause();
            throw new RuntimeException(cause.getMessage(), cause);
        }
    }
}

