/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.io.literal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.n52.javaps.io.Data;

public final class LiteralData
implements Data<Object> {
    private static final long serialVersionUID = -7088293056427203440L;
    private transient Optional<String> unitOfMeasurement;
    private final Object payload;

    public LiteralData(Object payload) {
        this(payload, null);
    }

    public LiteralData(Object payload, String unitOfMeasurment) {
        this.payload = Objects.requireNonNull(payload);
        this.unitOfMeasurement = Optional.ofNullable(unitOfMeasurment);
    }

    public Optional<String> getUnitOfMeasurement() {
        return this.unitOfMeasurement;
    }

    public void setUnitOfMeasurement(String unitOfMeasurement) {
        this.unitOfMeasurement = Optional.ofNullable(unitOfMeasurement);
    }

    @Override
    public Object getPayload() {
        return this.payload;
    }

    @Override
    public Class<?> getSupportedClass() {
        return Object.class;
    }

    private synchronized void writeObject(ObjectOutputStream oos) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (this.unitOfMeasurement.isPresent()) {
            out.write(this.unitOfMeasurement.get().getBytes(StandardCharsets.UTF_8));
        }
    }

    private void readObject(ObjectInputStream oos) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((Reader)new InputStreamReader((InputStream)oos, StandardCharsets.UTF_8), (Writer)writer);
        this.setUnitOfMeasurement(writer.toString());
    }
}

