/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.io.literal.xsd;

import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import org.n52.javaps.io.DecodingException;
import org.n52.javaps.io.literal.xsd.AbstractXSDLiteralType;
import org.n52.javaps.io.literal.xsd.Day;

public class LiteralDayType
extends AbstractXSDLiteralType<Day> {
    private static final long serialVersionUID = -8426376970434674190L;
    private static final DateTimeFormatter PARSER = DateTimeFormatter.ofPattern("---dd");

    @Override
    public String getName() {
        return "gDay";
    }

    @Override
    public Day parse(String value) throws DecodingException {
        try {
            return new Day(PARSER.parse(value).get(ChronoField.DAY_OF_MONTH));
        }
        catch (DateTimeException ex) {
            throw new DecodingException(ex);
        }
    }

    @Override
    public Class<Day> getPayloadType() {
        return Day.class;
    }

    @Override
    public String generate(Day value) {
        return String.format("--%02d", value.getAsInt());
    }
}

