/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.io.literal.xsd;

import java.time.DateTimeException;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import org.n52.javaps.io.DecodingException;
import org.n52.javaps.io.literal.xsd.AbstractXSDLiteralType;

public class LiteralMonthType
extends AbstractXSDLiteralType<Month> {
    private static final long serialVersionUID = -3702726667847500719L;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("--MM");

    @Override
    public String getName() {
        return "gMonth";
    }

    @Override
    public Month parse(String value) throws DecodingException {
        try {
            return Month.from(FORMATTER.parse(value));
        }
        catch (DateTimeException ex) {
            throw new DecodingException(ex);
        }
    }

    @Override
    public Class<Month> getPayloadType() {
        return Month.class;
    }

    @Override
    public String generate(Month value) {
        return FORMATTER.format(value);
    }
}

