/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.utils;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.n52.javaps.utils.Context;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringContext
implements Context,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    @Override
    public <T> T require(Class<T> type) {
        return (T)this.applicationContext.getBean(type);
    }

    @Override
    public <T> Optional<? extends T> getInstance(Class<T> type) {
        try {
            return Optional.of(this.applicationContext.getBean(type));
        }
        catch (NoSuchBeanDefinitionException ex) {
            return Optional.empty();
        }
    }

    @Override
    public <T> Collection<T> getInstances(Class<T> type) {
        return this.applicationContext.getBeansOfType(type).values();
    }

    @Override
    public <T> Collection<Object> getAnnotatedInstances(Class<? extends Annotation> annotation) {
        return this.applicationContext.getBeansWithAnnotation(annotation).values();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = Objects.requireNonNull(applicationContext);
    }
}

