/*
 * Copyright 2016-2022 52°North Spatial Information Research GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.n52.javaps.io;

import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;

import org.n52.shetland.ogc.wps.Format;

/**
 * TODO JavaDoc
 *
 * @author Christian Autermann
 */
public interface FormatRepository {

    Set<Format> getSupportedFormats();

    Set<Format> getSupportedFormats(Class<? extends Data<?>> binding);

    @SuppressWarnings("unchecked")
    default Set<Format> getSupportedFormats(Data<?> binding) {
        if (binding == null) {
            return Collections.emptySet();
        } else {
            return getSupportedFormats((Class<? extends Data<?>>) binding.getClass());
        }
    }

    default Optional<Format> getDefaultFormat(Class<? extends Data<?>> binding) {
        return getSupportedFormats(binding).stream().min(Comparator.naturalOrder());
    }
}
