/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.algorithm.annotation;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.Function;
import org.n52.javaps.algorithm.annotation.AbstractDataBinding;
import org.n52.javaps.algorithm.annotation.AbstractOutputAnnotationParser;
import org.n52.javaps.algorithm.annotation.AbstractOutputBinding;
import org.n52.javaps.algorithm.annotation.LiteralOutput;
import org.n52.javaps.description.TypedLiteralOutputDescription;
import org.n52.javaps.description.impl.TypedLiteralOutputDescriptionImpl;
import org.n52.javaps.description.impl.TypedProcessDescriptionFactory;
import org.n52.javaps.io.literal.LiteralType;
import org.n52.javaps.io.literal.LiteralTypeRepository;
import org.n52.shetland.ogc.wps.description.impl.LiteralDataDomainImpl;

class LiteralOutputAnnotationParser<M extends AccessibleObject, B extends AbstractOutputBinding<M>>
extends AbstractOutputAnnotationParser<LiteralOutput, M, B> {
    private final LiteralTypeRepository literalTypeRepository;

    LiteralOutputAnnotationParser(Function<M, B> bindingFunction, LiteralTypeRepository literalTypeRepository) {
        super(bindingFunction);
        this.literalTypeRepository = Objects.requireNonNull(literalTypeRepository, "literalDataManager");
    }

    @Override
    public Class<? extends LiteralOutput> getSupportedAnnotation() {
        return LiteralOutput.class;
    }

    public LiteralType<?> getLiteralType(LiteralOutput annotation, B binding) {
        Type payloadType = ((AbstractDataBinding)binding).getPayloadType();
        Class<? extends LiteralType> bindingType = annotation.binding();
        if (payloadType instanceof Class) {
            return this.literalTypeRepository.getLiteralType(bindingType, (Class)payloadType);
        }
        return this.literalTypeRepository.getLiteralType(bindingType);
    }

    @Override
    public TypedLiteralOutputDescription createDescription(LiteralOutput annotation, B binding) {
        LiteralType<?> bindingType = this.getLiteralType(annotation, binding);
        TypedProcessDescriptionFactory descriptionFactory = new TypedProcessDescriptionFactory();
        return ((TypedLiteralOutputDescriptionImpl.Builder)((TypedLiteralOutputDescriptionImpl.Builder)((TypedLiteralOutputDescriptionImpl.Builder)((TypedLiteralOutputDescriptionImpl.Builder)((TypedLiteralOutputDescriptionImpl.Builder)descriptionFactory.literalOutput().withTitle(annotation.title())).withAbstract(annotation.abstrakt())).withIdentifier(annotation.identifier())).withDefaultLiteralDataDomain(((LiteralDataDomainImpl.Builder)descriptionFactory.literalDataDomain().withDataType(bindingType.getDataType())).withUOM(annotation.uom()))).withType(bindingType)).build();
    }
}

