/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.commons;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.n52.janmayen.http.MediaType;
import org.n52.javaps.commons.FileExtensionProvider;

public class FileExtensions
implements FileExtensionProvider {
    private Map<MediaType, String> extensions;

    @Override
    public String getExtension(MediaType mediaType) {
        if (this.extensions.containsKey(mediaType)) {
            return this.extensions.get(mediaType);
        }
        Optional<String> extension = this.extensions.keySet().stream().filter(x -> x.isCompatible(mediaType)).findAny().map(this.extensions::get);
        if (extension.isPresent()) {
            return extension.get();
        }
        if (MediaType.anyText().isCompatible(mediaType)) {
            return "txt";
        }
        String subtype = mediaType.getSubtype();
        int idx = subtype.lastIndexOf(43);
        if (idx > 0 && idx < subtype.length() - 1) {
            return subtype.substring(idx + 1);
        }
        return subtype;
    }

    public void setExtensionsByString(Map<String, String> extensions) {
        this.setExtensionsByMediaType(extensions.entrySet().stream().collect(Collectors.toMap(x -> MediaType.parse((String)((String)x.getKey())), Map.Entry::getValue)));
    }

    public void setExtensionsByMediaType(Map<MediaType, String> extensions) {
        this.extensions = Objects.requireNonNull(extensions);
    }
}

