/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.io.literal.xsd;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.n52.javaps.io.DecodingException;
import org.n52.javaps.io.literal.xsd.AbstractXSDLiteralType;

public class LiteralDateType
extends AbstractXSDLiteralType<LocalDate> {
    private static final long serialVersionUID = -7185987979855377555L;

    @Override
    public String getName() {
        return "date";
    }

    @Override
    public LocalDate parse(String value) throws DecodingException {
        try {
            return LocalDate.from(DateTimeFormatter.ISO_DATE.parse(value));
        }
        catch (DateTimeException ex) {
            throw new DecodingException(ex);
        }
    }

    @Override
    public Class<LocalDate> getPayloadType() {
        return LocalDate.class;
    }

    @Override
    public String generate(LocalDate value) {
        return value.toString();
    }
}

