/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.io.literal.xsd;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.n52.javaps.io.DecodingException;
import org.n52.javaps.io.literal.xsd.AbstractXSDLiteralType;

public class LiteralNormalizedStringType
extends AbstractXSDLiteralType<String> {
    private static final long serialVersionUID = 4819263087679540611L;
    private static final Predicate<String> PATTERN = Pattern.compile("^[^\n\r\t]*$").asPredicate();

    @Override
    public String getName() {
        return "normalizedString";
    }

    @Override
    public String parse(String value) throws DecodingException {
        if (!PATTERN.test(value)) {
            throw new DecodingException("value is not a normalized string");
        }
        return value;
    }

    @Override
    public Class<String> getPayloadType() {
        return String.class;
    }

    @Override
    public String generate(String value) {
        return value;
    }
}

