/*
 * Copyright 2016-2023 52°North Spatial Information Research GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.n52.javaps.algorithm;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.n52.javaps.commons.observerpattern.IObserver;
import org.n52.javaps.commons.observerpattern.ISubject;

/**
 *
 * @author Christian Autermann
 */
public abstract class AbstractObservable implements ISubject {

    private final List<IObserver> observers = Collections.synchronizedList(new LinkedList<>());

    private Object state;

    @Override
    public void addObserver(IObserver o) {
        this.observers.add(o);
    }

    @Override
    public void removeObserver(IObserver o) {
        this.observers.remove(o);
    }

    public void notifyObservers() {
        this.observers.stream().forEach(o -> o.update(this));
    }

    @Override
    public Object getState() {
        return state;
    }

    @Override
    public void update(Object state) {
        this.state = state;
        notifyObservers();
    }
}
