/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.algorithm;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.n52.javaps.algorithm.AlgorithmRepository;
import org.n52.javaps.algorithm.IAlgorithm;
import org.n52.javaps.description.TypedProcessDescription;
import org.n52.javaps.description.TypedProcessInputDescription;
import org.n52.javaps.description.TypedProcessOutputDescription;
import org.n52.shetland.ogc.ows.OwsCode;

public class RepositoryManager {
    private final Set<OwsCode> globalProcessIDs = Collections.synchronizedSet(new HashSet());
    private Set<AlgorithmRepository> repositories;

    private Stream<AlgorithmRepository> getRepositories() {
        return this.repositories.stream();
    }

    @Inject
    public void setRepositories(Set<AlgorithmRepository> repositories) {
        this.repositories = repositories;
    }

    public Optional<IAlgorithm> getAlgorithm(OwsCode id) {
        return this.getRepositoryForAlgorithm(id).flatMap(r -> r.getAlgorithm(id));
    }

    public Set<OwsCode> getAlgorithms() {
        return this.getRepositories().flatMap(r -> r.getAlgorithmNames().stream()).collect(Collectors.toSet());
    }

    public boolean containsAlgorithm(OwsCode id) {
        return this.getRepositoryForAlgorithm(id).isPresent();
    }

    public Optional<AlgorithmRepository> getRepositoryForAlgorithm(OwsCode id) {
        return this.getRepositories().filter(repo -> repo.containsAlgorithm(id)).findFirst();
    }

    public Optional<TypedProcessInputDescription<?>> getInputForAlgorithm(OwsCode process, OwsCode input) {
        return this.getProcessDescription(process).map(x -> x.getInput(input));
    }

    public Optional<TypedProcessOutputDescription<?>> getOutputForAlgorithm(OwsCode process, OwsCode output) {
        return this.getProcessDescription(process).map(x -> x.getOutput(output));
    }

    public boolean registerAlgorithm(OwsCode id, AlgorithmRepository repository) {
        return this.globalProcessIDs.add(id);
    }

    public boolean unregisterAlgorithm(OwsCode id) {
        return this.globalProcessIDs.remove(id);
    }

    public Optional<TypedProcessDescription> getProcessDescription(String id) {
        return this.getProcessDescription(new OwsCode(id));
    }

    public Optional<TypedProcessDescription> getProcessDescription(OwsCode id) {
        return this.getRepositoryForAlgorithm(id).flatMap(r -> r.getProcessDescription(id));
    }
}

