/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.algorithm.annotation;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.function.Function;
import org.n52.javaps.algorithm.annotation.AbstractDataBinding;
import org.n52.javaps.description.TypedProcessOutputDescription;
import org.n52.javaps.io.Data;
import org.n52.javaps.io.literal.LiteralData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractOutputBinding<M extends AccessibleObject>
extends AbstractDataBinding<M, TypedProcessOutputDescription<?>> {
    private static final String INTERNAL_ERROR_PROCESSING_OUTPUTS = "Internal error processing outputs";
    private Function<Object, ? extends Data<?>> bindingConstructor;

    AbstractOutputBinding(M member) {
        super(member);
    }

    protected boolean checkType() {
        return this.getConstructor() != null;
    }

    protected Data<?> bindOutputValue(Object outputValue) {
        return this.getConstructor().apply(this.outputToPayload(outputValue));
    }

    public abstract Data<?> get(Object var1);

    private synchronized Function<Object, ? extends Data<?>> getConstructor() {
        if (this.bindingConstructor == null) {
            this.bindingConstructor = this.findConstructor();
        }
        return this.bindingConstructor;
    }

    private Function<Object, ? extends Data<?>> findConstructor() {
        if (((TypedProcessOutputDescription)this.getDescription()).isLiteral()) {
            return LiteralData::new;
        }
        Class bindingClass = ((TypedProcessOutputDescription)this.getDescription()).getBindingType();
        Class outputPayloadClass = ((TypedProcessOutputDescription)this.getDescription()).getPayloadType();
        Type bindingPayloadType = this.getPayloadType();
        if (!(bindingPayloadType instanceof Class)) {
            return null;
        }
        Class bindingPayloadClass = (Class)bindingPayloadType;
        if (!bindingPayloadClass.isAssignableFrom(outputPayloadClass) || Modifier.isAbstract(bindingClass.getModifiers())) {
            return null;
        }
        try {
            Constructor constructor = bindingClass.getConstructor(bindingPayloadClass);
            if (constructor == null || !Modifier.isPublic(constructor.getModifiers())) {
                return null;
            }
            return arg -> {
                try {
                    return (Data)constructor.newInstance(arg);
                }
                catch (IllegalAccessException | InstantiationException | SecurityException ex) {
                    throw new RuntimeException(INTERNAL_ERROR_PROCESSING_OUTPUTS, ex);
                }
                catch (InvocationTargetException ex) {
                    Throwable cause = ex.getCause() == null ? ex : ex.getCause();
                    throw new RuntimeException(cause.getMessage(), cause);
                }
            };
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static AbstractOutputBinding<Field> field(Field field) {
        return new OutputFieldBinding(field);
    }

    public static AbstractOutputBinding<Method> method(Method method) {
        return new OutputMethodBinding(method);
    }

    private static class OutputFieldBinding
    extends AbstractOutputBinding<Field> {
        private static final Logger LOGGER = LoggerFactory.getLogger(OutputFieldBinding.class);

        OutputFieldBinding(Field field) {
            super(field);
        }

        @Override
        public Type getMemberType() {
            return ((Field)this.getMember()).getGenericType();
        }

        @Override
        public boolean validate() {
            if (!this.checkModifier()) {
                LOGGER.error("Field {} with output annotation can't be used, not public.", this.getMember());
                return false;
            }
            if (!this.checkType()) {
                LOGGER.error("Field {} with output annotation can't be used, unable to safely construct binding using field type", this.getMember());
                return false;
            }
            return true;
        }

        @Override
        public Data<?> get(Object instance) {
            Object value;
            try {
                value = ((Field)this.getMember()).get(instance);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new RuntimeException(AbstractOutputBinding.INTERNAL_ERROR_PROCESSING_OUTPUTS, ex);
            }
            return value == null ? null : this.bindOutputValue(value);
        }
    }

    private static class OutputMethodBinding
    extends AbstractOutputBinding<Method> {
        private static final Logger LOGGER = LoggerFactory.getLogger(OutputMethodBinding.class);

        OutputMethodBinding(Method method) {
            super(method);
        }

        @Override
        public Type getMemberType() {
            return ((Method)this.getMember()).getGenericReturnType();
        }

        @Override
        public boolean validate() {
            Method method = (Method)this.getMember();
            if (method.getParameterTypes().length != 0) {
                LOGGER.error("Method {} with output annotation can't be used, parameter count != 0", this.getMember());
                return false;
            }
            if (!this.checkModifier()) {
                LOGGER.error("Method {} with output annotation can't be used, not public", this.getMember());
                return false;
            }
            if (!this.checkType()) {
                LOGGER.error("Method {} with output annotation can't be used, unable to safely construct binding using method return type", this.getMember());
                return false;
            }
            return true;
        }

        @Override
        public Data<?> get(Object instance) {
            Object value;
            try {
                value = ((Method)this.getMember()).invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new RuntimeException(AbstractOutputBinding.INTERNAL_ERROR_PROCESSING_OUTPUTS, ex);
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause() == null ? ex : ex.getCause();
                throw new RuntimeException(cause.getMessage(), cause);
            }
            return value == null ? null : this.bindOutputValue(value);
        }
    }
}

