/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.algorithm.annotation;

import java.lang.reflect.AccessibleObject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.function.Function;
import org.n52.javaps.algorithm.annotation.AbstractInputAnnotationParser;
import org.n52.javaps.algorithm.annotation.AbstractInputBinding;
import org.n52.javaps.algorithm.annotation.BoundingBoxInput;
import org.n52.javaps.description.TypedBoundingBoxInputDescription;
import org.n52.javaps.description.impl.TypedBoundingBoxInputDescriptionImpl;
import org.n52.javaps.description.impl.TypedProcessDescriptionFactory;
import org.n52.shetland.ogc.ows.OwsCRS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BoundingBoxInputAnnotationParser<M extends AccessibleObject, B extends AbstractInputBinding<M>>
extends AbstractInputAnnotationParser<BoundingBoxInput, M, B> {
    private static final Logger LOG = LoggerFactory.getLogger(BoundingBoxInputAnnotationParser.class);
    private static final String COULD_NOT_CREATE_URI_FROM_STRING = "Could not create URI from String: ";

    BoundingBoxInputAnnotationParser(Function<M, B> bindingFunction) {
        super(bindingFunction);
    }

    @Override
    protected TypedBoundingBoxInputDescription createDescription(BoundingBoxInput annotation, B binding) {
        String[] supportedCRSArray;
        URI defaultCRSURI = null;
        try {
            defaultCRSURI = new URI(annotation.defaultCRSString());
        }
        catch (URISyntaxException e) {
            LOG.error(COULD_NOT_CREATE_URI_FROM_STRING + annotation.defaultCRSString());
            defaultCRSURI = URI.create("http://www.opengis.net/def/crs/EPSG/0/4326");
        }
        ArrayList<OwsCRS> supportedCRSList = new ArrayList<OwsCRS>();
        for (String crsString : supportedCRSArray = annotation.supportedCRSStringArray()) {
            try {
                supportedCRSList.add(new OwsCRS(new URI(crsString)));
            }
            catch (URISyntaxException e) {
                LOG.error(COULD_NOT_CREATE_URI_FROM_STRING + crsString);
            }
        }
        return ((TypedBoundingBoxInputDescriptionImpl.Builder)((TypedBoundingBoxInputDescriptionImpl.Builder)((TypedBoundingBoxInputDescriptionImpl.Builder)((TypedBoundingBoxInputDescriptionImpl.Builder)((TypedBoundingBoxInputDescriptionImpl.Builder)((TypedBoundingBoxInputDescriptionImpl.Builder)((TypedBoundingBoxInputDescriptionImpl.Builder)new TypedProcessDescriptionFactory().boundingBoxInput().withIdentifier(annotation.identifier())).withAbstract(annotation.abstrakt())).withTitle(annotation.title())).withMinimalOccurence(annotation.minOccurs())).withMaximalOccurence(annotation.maxOccurs())).withDefaultCRS(new OwsCRS(defaultCRSURI))).withSupportedCRS(supportedCRSList)).build();
    }

    @Override
    public Class<? extends BoundingBoxInput> getSupportedAnnotation() {
        return BoundingBoxInput.class;
    }
}

