/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.engine;

import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.n52.janmayen.Chain;
import org.n52.shetland.ogc.ows.OwsCode;
import org.n52.shetland.ogc.wps.JobId;

public class OutputReference
implements Iterable<OwsCode> {
    private static final String JOB_ID_STRING = "jobId";
    private static final String OUTPUT_ID_STRING = "outputId";
    private final JobId jobId;
    private final Chain<OwsCode> outputId;

    public OutputReference(JobId jobId, Chain<OwsCode> outputId) {
        this.jobId = Objects.requireNonNull(jobId, JOB_ID_STRING);
        this.outputId = Objects.requireNonNull(outputId, OUTPUT_ID_STRING);
    }

    public OutputReference(JobId jobId, OwsCode outputId) {
        this.jobId = Objects.requireNonNull(jobId, JOB_ID_STRING);
        this.outputId = new Chain((Object)Objects.requireNonNull(outputId, OUTPUT_ID_STRING));
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public Chain<OwsCode> getOutputId() {
        return this.outputId;
    }

    public OwsCode first() {
        return (OwsCode)this.outputId.first();
    }

    public OwsCode last() {
        return (OwsCode)this.outputId.last();
    }

    public Optional<OutputReference> tail() {
        return this.outputId.tail().map(chain -> new OutputReference(this.jobId, (Chain<OwsCode>)chain));
    }

    public OutputReference child(OwsCode t) {
        return new OutputReference(this.jobId, (Chain<OwsCode>)this.outputId.child((Object)t));
    }

    public OutputReference child(Chain<OwsCode> t) {
        return new OutputReference(this.jobId, (Chain<OwsCode>)this.outputId.child(t));
    }

    public Optional<OutputReference> parent() {
        return this.outputId.parent().map(chain -> new OutputReference(this.jobId, (Chain<OwsCode>)chain));
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.outputId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OutputReference other = (OutputReference)obj;
        return Objects.equals(this.jobId, other.getJobId()) && Objects.equals(this.outputId, other.getOutputId());
    }

    public String toString() {
        return "OutputReference{jobId=" + this.jobId + ", outputId=" + this.outputId + '}';
    }

    @Override
    public Iterator<OwsCode> iterator() {
        return this.outputId.iterator();
    }
}

