/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.io;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Provider;
import org.n52.javaps.io.Data;
import org.n52.javaps.io.FormatRepository;
import org.n52.javaps.io.InputOutputHandler;
import org.n52.shetland.ogc.wps.Format;

public abstract class AbstractInputOutputHandlerRepository<T extends InputOutputHandler>
implements FormatRepository {
    @Override
    public Set<Format> getSupportedFormats() {
        return this.stream().map(InputOutputHandler::getSupportedFormats).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public Set<Format> getSupportedFormats(Class<? extends Data<?>> binding) {
        return this.stream().filter(g -> g.isSupportedBinding(binding)).map(InputOutputHandler::getSupportedFormats).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    protected Optional<T> getHandler(Class<? extends Data<?>> binding, Format format) {
        return this.stream().filter(g -> g.isSupportedBinding(binding)).filter(g -> g.isSupportedFormat(format)).findFirst();
    }

    protected Set<T> getHandlers() {
        return Collections.unmodifiableSet(this.stream().collect(Collectors.toSet()));
    }

    protected abstract Set<Provider<T>> getHandlerProviders();

    protected Stream<T> stream() {
        return this.getHandlerProviders().stream().map(Provider::get);
    }
}

