/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.io.literal.xsd;

import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.n52.javaps.io.DecodingException;
import org.n52.javaps.io.literal.xsd.AbstractXSDLiteralType;

public class LiteralDateTimeType
extends AbstractXSDLiteralType<LocalDateTime> {
    private static final long serialVersionUID = 4633193913270532243L;

    @Override
    public String getName() {
        return "dateTime";
    }

    @Override
    public LocalDateTime parse(String value) throws DecodingException {
        try {
            return LocalDateTime.from(DateTimeFormatter.ISO_DATE_TIME.parse(value));
        }
        catch (DateTimeException ex) {
            throw new DecodingException(ex);
        }
    }

    @Override
    public Class<LocalDateTime> getPayloadType() {
        return LocalDateTime.class;
    }

    @Override
    public String generate(LocalDateTime value) {
        return value.atOffset(ZoneOffset.UTC).toString();
    }
}

