/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import org.n52.iceland.coding.encode.ResponseProxy;
import org.n52.iceland.coding.encode.ResponseWriter;
import org.n52.iceland.coding.encode.ResponseWriterKey;
import org.n52.janmayen.http.MediaType;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.NoEncoderForKeyException;
import org.n52.svalbard.encode.stream.StreamWriter;
import org.n52.svalbard.encode.stream.StreamWriterKey;
import org.n52.svalbard.encode.stream.StreamWriterRepository;

public class StreamingServiceResponseWriter
implements ResponseWriter<OwsServiceResponse> {
    public static final ResponseWriterKey KEY = new ResponseWriterKey(OwsServiceResponse.class);
    private MediaType contentType;
    private final StreamWriterRepository repository;

    public StreamingServiceResponseWriter(StreamWriterRepository streamWriterRepository) {
        this.repository = streamWriterRepository;
    }

    public MediaType getContentType() {
        return this.contentType;
    }

    public void setContentType(MediaType contentType) {
        this.contentType = contentType;
    }

    public void write(OwsServiceResponse t, OutputStream out, ResponseProxy responseProxy) throws IOException, EncodingException {
        StreamWriterKey key = new StreamWriterKey(t.getClass(), t.getContentType());
        StreamWriter<OwsServiceResponse> writer = this.repository.getWriter(key).orElseThrow(() -> new NoEncoderForKeyException((Object)key));
        writer.write(t, out);
    }

    public boolean supportsGZip(OwsServiceResponse t) {
        return true;
    }

    public Set<ResponseWriterKey> getKeys() {
        return Collections.singleton(KEY);
    }
}

