/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode.stream.xml;

import com.google.common.base.Strings;
import com.google.common.escape.Escaper;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import com.google.common.xml.XmlEscapers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import org.joda.time.DateTime;
import org.n52.iceland.util.XmlFactories;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePosition;
import org.n52.shetland.util.DateTimeHelper;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.shetland.w3c.W3CConstants;
import org.n52.shetland.w3c.xlink.Actuate;
import org.n52.shetland.w3c.xlink.Link;
import org.n52.shetland.w3c.xlink.Show;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.stream.xml.ElementXmlStreamWriter;
import org.n52.svalbard.encode.stream.xml.XmlStreamWritingContext;
import org.n52.svalbard.stream.XLinkConstants;

public abstract class AbstractElementXmlStreamWriter
extends XmlFactories
implements ElementXmlStreamWriter {
    private static final Escaper ESCAPER = XmlEscapers.xmlContentEscaper();
    private XmlStreamWritingContext context;

    @Override
    public void setContext(XmlStreamWritingContext context) {
        this.context = Objects.requireNonNull(context);
    }

    protected XmlStreamWritingContext context() {
        return this.context;
    }

    protected void attr(QName name, String value) throws XMLStreamException {
        this.context().dispatch(this.eventFactory().createAttribute(name, value));
    }

    protected void attr(QName name, Optional<String> value) throws XMLStreamException {
        if (value.isPresent()) {
            this.attr(name, value.get());
        }
    }

    protected void attr(String name, Optional<String> value) throws XMLStreamException {
        this.attr(new QName(name), value);
    }

    protected void attr(String name, String value) throws XMLStreamException {
        this.attr(new QName(name), value);
    }

    protected <T> void attr(QName name, Collection<? extends T> coll, Function<T, String> mapper) throws XMLStreamException {
        if (coll != null && !coll.isEmpty()) {
            this.attr(name, coll.stream().map(mapper).collect(Collectors.joining(" ")));
        }
    }

    protected void attr(String namespace, String localName, String value) throws XMLStreamException {
        this.attr(new QName(namespace, localName), value);
    }

    protected <T> void attr(String name, Collection<? extends T> coll, Function<T, String> mapper) throws XMLStreamException {
        this.attr(new QName(name), coll, mapper);
    }

    protected void namespace(String prefix, String namespace) throws XMLStreamException {
        if (this.context().declareNamespace(prefix, namespace)) {
            this.context().dispatch(this.eventFactory().createNamespace(prefix, namespace));
        }
    }

    protected void start(String namespace, String localName) throws XMLStreamException {
        this.start(new QName(namespace, localName));
    }

    protected void start(String namespace, String localName, String prefix) throws XMLStreamException {
        this.start(new QName(namespace, localName, prefix));
    }

    protected void start(QName name) throws XMLStreamException {
        this.context().dispatch(this.eventFactory().createStartElement(name.getPrefix(), name.getNamespaceURI(), name.getLocalPart()));
    }

    protected void empty(QName name) throws XMLStreamException {
        this.start(name);
        this.end(name);
    }

    protected void chars(String chars) throws XMLStreamException {
        this.context().dispatch(this.eventFactory().createCharacters(chars));
    }

    protected void chars(String chars, boolean escape) throws XMLStreamException {
        this.context().dispatch(this.eventFactory().createCharacters(escape ? AbstractElementXmlStreamWriter.escaper().escape(chars) : chars));
    }

    protected void end(QName name) throws XMLStreamException {
        this.context().dispatch(this.eventFactory().createEndElement(name.getPrefix(), name.getNamespaceURI(), name.getLocalPart()));
    }

    protected void write(Reader in) throws XMLStreamException {
        this.context().write(in);
    }

    protected void write(XMLEventReader reader) throws XMLStreamException {
        this.context().write(reader);
    }

    protected void flush() throws XMLStreamException {
        this.context().flush();
    }

    protected void cdata(String value) throws XMLStreamException {
        this.context().dispatch(this.eventFactory().createCData(value));
    }

    protected void writeBase64(InputStream data) throws IOException {
        try (CharacterEmittingWriter writer = new CharacterEmittingWriter();
             OutputStream encodingStream = AbstractElementXmlStreamWriter.base64().encodingStream((Writer)writer);){
            ByteStreams.copy((InputStream)data, (OutputStream)encodingStream);
        }
    }

    protected void time(TimeInstant time) throws XMLStreamException {
        this.time(time.getTimePosition());
    }

    protected void time(TimePosition time) throws XMLStreamException {
        this.chars(DateTimeHelper.formatDateTime2IsoString((DateTime)time.getTime()));
    }

    protected void schemaLocation(Set<SchemaLocation> schemaLocations) throws XMLStreamException {
        String merged = AbstractElementXmlStreamWriter.mergeSchemaLocationsToString(schemaLocations);
        if (!Strings.isNullOrEmpty((String)merged)) {
            this.namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.attr(W3CConstants.QN_SCHEMA_LOCATION_PREFIXED, merged);
        }
    }

    protected void writeXLinkAttrs(Link link) throws XMLStreamException {
        this.namespace("xlink", "http://www.w3.org/1999/xlink");
        this.attr(XLinkConstants.Attr.QN_HREF, link.getHref().map(URI::toString));
        this.attr(XLinkConstants.Attr.QN_ROLE, link.getRole().map(URI::toString));
        this.attr(XLinkConstants.Attr.QN_SHOW, link.getShow().map(Show::toString));
        this.attr(XLinkConstants.Attr.QN_TITLE, (Optional<String>)link.getTitle());
        this.attr(XLinkConstants.Attr.QN_ARCROLE, link.getArcrole().map(URI::toString));
        this.attr(XLinkConstants.Attr.QN_ACTUATE, link.getActuate().map(Actuate::toString));
    }

    protected void writeLink(QName name, Link link) throws XMLStreamException {
        this.element(name, link, this::writeXLinkAttrs);
    }

    protected void element(QName name, String value) throws XMLStreamException {
        this.start(name);
        this.chars(value);
        this.end(name);
    }

    protected void element(QName name, Optional<String> value) throws XMLStreamException {
        if (value.isPresent()) {
            this.element(name, value.get());
        }
    }

    protected void element(QName name, OffsetDateTime time) throws XMLStreamException {
        this.element(name, this.format(time));
    }

    protected <T> void element(QName name, Optional<? extends T> elem, ElementWriter<? super T> writer) throws XMLStreamException {
        if (elem.isPresent()) {
            this.start(name);
            writer.write(elem.get());
            this.end(name);
        }
    }

    protected <T> void element(QName name, T elem, ElementWriter<? super T> writer) throws XMLStreamException {
        if (elem != null) {
            this.start(name);
            writer.write(elem);
            this.end(name);
        }
    }

    protected <T> void element(QName name, ContentWriter writer) throws XMLStreamException {
        this.start(name);
        writer.write();
        this.end(name);
    }

    protected <T> void delegate(T object) throws XMLStreamException, EncodingException {
        this.context().write(object);
    }

    protected String format(OffsetDateTime time) {
        return DateTimeFormatter.ISO_DATE_TIME.format(time);
    }

    protected <T> void forEach(QName name, Iterable<? extends T> elements, ElementWriter<? super T> writer) throws XMLStreamException {
        if (elements != null) {
            for (T elem : elements) {
                this.start(name);
                writer.write(elem);
                this.end(name);
            }
        }
    }

    protected void writeXML(String xml) throws XMLStreamException {
        try (StringReader reader = new StringReader(xml);){
            this.write(reader);
        }
    }

    protected static BaseEncoding base64() {
        return BaseEncoding.base64().withSeparator("\n", 80);
    }

    private static String mergeSchemaLocationsToString(Iterable<SchemaLocation> schemaLocations) {
        if (schemaLocations == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Iterator<SchemaLocation> it = schemaLocations.iterator();
        if (it.hasNext()) {
            builder.append(it.next().getSchemaLocationString());
            while (it.hasNext()) {
                builder.append(" ").append(it.next().getSchemaLocationString());
            }
        }
        return builder.toString();
    }

    protected static Escaper escaper() {
        return ESCAPER;
    }

    private class CharacterEmittingWriter
    extends Writer {
        private boolean closed;

        private CharacterEmittingWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.checkNotClosed();
            this.write(new String(cbuf, off, len));
        }

        @Override
        public void write(String str) throws IOException {
            this.checkNotClosed();
            try {
                AbstractElementXmlStreamWriter.this.chars(str);
            }
            catch (XMLStreamException ex) {
                throw new IOException(ex);
            }
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            this.checkNotClosed();
            this.write(str.substring(off, len));
        }

        @Override
        public void flush() throws IOException {
            this.checkNotClosed();
            try {
                AbstractElementXmlStreamWriter.this.flush();
            }
            catch (XMLStreamException ex) {
                throw new IOException(ex);
            }
        }

        @Override
        public void close() {
            this.closed = true;
        }

        private void checkNotClosed() throws IOException {
            if (this.closed) {
                throw new IOException("already closed");
            }
        }
    }

    @FunctionalInterface
    protected static interface ContentWriter {
        public void write() throws XMLStreamException;
    }

    @FunctionalInterface
    protected static interface ElementWriter<T> {
        public void write(T var1) throws XMLStreamException;
    }
}

