/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode.stream.xml;

import com.google.common.base.Strings;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.n52.iceland.util.XmlFactories;
import org.n52.svalbard.decode.stream.xml.ElementXmlStreamReader;

public abstract class AbstractElementXmlStreamReader
extends XmlFactories
implements ElementXmlStreamReader {
    private static final String PREFIX_XML = "xml";

    protected byte[] asBytes(StartElement start, XMLEventReader reader) throws XMLStreamException {
        return this.asString(start, reader).getBytes(StandardCharsets.UTF_8);
    }

    protected String asString(StartElement start, XMLEventReader reader) throws XMLStreamException {
        StringWriter stringWriter = new StringWriter();
        XMLEventWriter writer = this.outputFactory().createXMLEventWriter(stringWriter);
        this.copy(reader, writer);
        writer.close();
        return stringWriter.toString();
    }

    protected void copy(XMLEventReader reader, XMLEventWriter writer) throws XMLStreamException {
        int depth = 0;
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement elem = event.asStartElement();
                QName elementName = elem.getName();
                String elementPrefix = elementName.getPrefix();
                String elementNamespace = elementName.getNamespaceURI();
                boolean writeElementNamespace = !elementPrefix.isEmpty() && !elementPrefix.equals(PREFIX_XML) && Strings.isNullOrEmpty((String)writer.getNamespaceContext().getNamespaceURI(elementPrefix));
                writer.add(this.eventFactory().createStartElement(elementName, null, null));
                Iterator<Namespace> namespaces = elem.getNamespaces();
                while (namespaces.hasNext()) {
                    Namespace namespace = namespaces.next();
                    if (elementPrefix.equals(namespace.getPrefix()) && elementNamespace.equals(namespace.getNamespaceURI())) {
                        writeElementNamespace = false;
                    }
                    writer.add(this.eventFactory().createNamespace(Strings.nullToEmpty((String)namespace.getPrefix()), namespace.getNamespaceURI()));
                }
                if (writeElementNamespace) {
                    writer.add(this.eventFactory().createNamespace(Strings.nullToEmpty((String)elementPrefix), elementNamespace));
                }
                Iterator<Attribute> attributes = elem.getAttributes();
                while (attributes.hasNext()) {
                    Attribute attribute = attributes.next();
                    String attributePrefix = attribute.getName().getPrefix();
                    String attributeNamespace = attribute.getName().getNamespaceURI();
                    if (!attributePrefix.isEmpty() && !attributePrefix.equals(PREFIX_XML) && Strings.isNullOrEmpty((String)writer.getNamespaceContext().getNamespaceURI(attributePrefix))) {
                        writer.add(this.eventFactory().createNamespace(attributePrefix, attributeNamespace));
                    }
                    writer.add(this.eventFactory().createAttribute(attribute.getName(), attribute.getValue()));
                }
                ++depth;
                continue;
            }
            if (event.isEndElement()) {
                if (--depth >= 0) {
                    writer.add(event);
                    continue;
                }
                return;
            }
            writer.add(event);
        }
        throw this.eof();
    }

    protected static Optional<String> getAttribute(StartElement event, QName name) {
        Attribute attr = event.getAttributeByName(name);
        return Optional.ofNullable(attr).map(Attribute::getValue);
    }

    protected static Optional<String> getAttribute(StartElement event, String name) {
        return AbstractElementXmlStreamReader.getAttribute(event, new QName(name));
    }
}

