/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode.stream.xml;

import java.io.InputStream;
import java.util.Set;
import javax.inject.Inject;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.n52.iceland.util.XmlFactories;
import org.n52.janmayen.component.Component;
import org.n52.shetland.ogc.ows.exception.NoApplicableCodeException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.svalbard.decode.stream.MissingStreamReaderException;
import org.n52.svalbard.decode.stream.StreamReader;
import org.n52.svalbard.decode.stream.StreamReaderKey;
import org.n52.svalbard.decode.stream.xml.ElementXmlStreamReaderRepository;
import org.n52.svalbard.decode.stream.xml.XmlStreamReaderKey;

public class DocumentXmlStreamReader
extends XmlFactories
implements StreamReader<Object>,
Component<StreamReaderKey> {
    private final ElementXmlStreamReaderRepository repository;

    @Inject
    public DocumentXmlStreamReader(ElementXmlStreamReaderRepository delegate) {
        this.repository = delegate;
    }

    private Object read(XMLEventReader reader) throws XMLStreamException {
        Object object = null;
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartDocument()) {
                object = this.readDocumentElement(reader);
                continue;
            }
            if (!event.isEndDocument()) continue;
            return object;
        }
        throw this.eof();
    }

    @Override
    public Object read(InputStream stream) throws OwsExceptionReport {
        try {
            return this.read(this.inputFactory().createXMLEventReader(stream));
        }
        catch (XMLStreamException ex) {
            throw new NoApplicableCodeException().causedBy((Throwable)ex);
        }
    }

    private Object readDocumentElement(XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            if (reader.peek().isStartElement()) {
                StartElement elem = reader.peek().asStartElement();
                XmlStreamReaderKey key = new XmlStreamReaderKey(elem.getName());
                return this.repository.get(key).orElseThrow(() -> new MissingStreamReaderException(key)).readElement(reader);
            }
            reader.next();
        }
        throw this.eof();
    }

    public Set<StreamReaderKey> getKeys() {
        return this.repository.keys();
    }
}

