/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode.stream;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import org.n52.janmayen.component.AbstractSimilarityKeyRepository;
import org.n52.janmayen.http.MediaType;
import org.n52.janmayen.lifecycle.Constructable;
import org.n52.svalbard.encode.stream.StreamWriter;
import org.n52.svalbard.encode.stream.StreamWriterKey;

public class StreamWriterRepository
extends AbstractSimilarityKeyRepository<StreamWriterKey, StreamWriter<?>>
implements Constructable {
    private Collection<Provider<StreamWriter<?>>> writers;

    public void init() {
        Objects.requireNonNull(this.writers);
        this.setProducers(this.writers);
    }

    public <T> Optional<StreamWriter<? super T>> getWriter(MediaType mediaType, Class<? extends T> type) {
        return this.getWriter(new StreamWriterKey(type, mediaType));
    }

    public <T> Optional<StreamWriter<? super T>> getWriter(StreamWriterKey key) {
        return this.get(key).map(x -> x);
    }

    @Inject
    public void set(Optional<Collection<Provider<StreamWriter<?>>>> writers) {
        this.writers = writers.orElseGet(Collections::emptyList);
    }
}

