/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode.stream.xml;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.n52.iceland.util.XmlFactories;
import org.n52.janmayen.function.ThrowingConsumer;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.stream.StreamWriter;
import org.n52.svalbard.encode.stream.StreamWriterKey;
import org.n52.svalbard.encode.stream.xml.ElementXmlStreamWriterRepository;
import org.n52.svalbard.encode.stream.xml.XmlStreamWritingContext;

public class DocumentXmlStreamWriter
extends XmlFactories
implements StreamWriter<Object> {
    private final ElementXmlStreamWriterRepository repository;
    private final ExecutorService executor;

    @Inject
    public DocumentXmlStreamWriter(ElementXmlStreamWriterRepository repository) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("xml-transformer-%d").build();
        this.executor = Executors.newCachedThreadPool(threadFactory);
        this.repository = Objects.requireNonNull(repository);
    }

    @Override
    public void write(Object object, OutputStream stream) throws EncodingException {
        try {
            this.writeIndenting(stream, out -> {
                try (XmlStreamWritingContext context = this.createContext((OutputStream)out);){
                    context.startDocument();
                    context.write(object);
                    context.endDocument();
                }
                catch (XMLStreamException ex) {
                    throw new EncodingException((Throwable)ex);
                }
            });
        }
        catch (IOException | InterruptedException | TransformerException ex) {
            throw new EncodingException((Throwable)ex);
        }
    }

    private <X extends Exception> void writeIndenting(OutputStream stream, ThrowingConsumer<OutputStream, X> writer) throws X, TransformerException, IOException, InterruptedException {
        try {
            PipedOutputStream pos = new PipedOutputStream();
            PipedInputStream pis = new PipedInputStream(pos);
            Transformer transformer = this.createIndentingTransformer();
            Future<Void> t = this.executor.submit(() -> {
                try {
                    StreamResult result = new StreamResult(stream);
                    StreamSource source = new StreamSource(pis);
                    transformer.transform(source, result);
                }
                finally {
                    pis.close();
                }
                return null;
            });
            try {
                writer.accept((Object)pos);
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw e;
            }
            t.get();
        }
        catch (ExecutionException ex) {
            Throwables.throwIfInstanceOf((Throwable)ex.getCause(), TransformerException.class);
            Throwables.throwIfInstanceOf((Throwable)ex.getCause(), IOException.class);
            Throwables.throwIfUnchecked((Throwable)ex.getCause());
            throw new RuntimeException(ex.getCause());
        }
    }

    public Set<StreamWriterKey> getKeys() {
        return this.repository.keys();
    }

    private XmlStreamWritingContext createContext(OutputStream pos) throws XMLStreamException {
        return new XmlStreamWritingContext(pos, this.repository::get);
    }
}

