/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode.stream.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.n52.iceland.util.XmlFactories;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.stream.MissingStreamWriterException;
import org.n52.svalbard.encode.stream.xml.ElementXmlStreamWriter;
import org.n52.svalbard.encode.stream.xml.XmlStreamWriterKey;

public class XmlStreamWritingContext
extends XmlFactories
implements AutoCloseable {
    private final Deque<Map<String, String>> prefixes = new ArrayDeque<Map<String, String>>();
    private final XMLEventWriter writer;
    private final BiFunction<XmlStreamWriterKey, XmlStreamWritingContext, Optional<ElementXmlStreamWriter>> writerProvider;
    private final OutputStream stream;

    public XmlStreamWritingContext(OutputStream stream, BiFunction<XmlStreamWriterKey, XmlStreamWritingContext, Optional<ElementXmlStreamWriter>> writerProvider) throws XMLStreamException {
        this.stream = Objects.requireNonNull(stream);
        this.writer = this.outputFactory().createXMLEventWriter(stream, this.documentEncoding().name());
        this.writerProvider = Objects.requireNonNull(writerProvider);
    }

    public <T> void write(T object) throws XMLStreamException, EncodingException {
        if (object != null) {
            XmlStreamWriterKey key = new XmlStreamWriterKey(object.getClass());
            ElementXmlStreamWriter delegate = this.writerProvider.apply(key, this).orElseThrow(() -> new MissingStreamWriterException(key));
            delegate.writeElement(object);
        }
    }

    public void write(Reader in) throws XMLStreamException {
        try (XMLEventReader reader = this.inputFactory().createXMLEventReader(in);){
            this.write(reader);
        }
    }

    public void write(XMLEventReader reader) throws XMLStreamException {
        EventFilter filter = event -> !event.isStartDocument() && !event.isEndDocument() && (!event.isCharacters() || !event.asCharacters().isIgnorableWhiteSpace());
        this.writer.add(this.inputFactory().createFilteredReader(reader, filter));
    }

    public <X, Y> Function<X, Y> identity(Function<X, Y> t) {
        return t;
    }

    public boolean declareNamespace(String prefix, String namespace) throws XMLStreamException {
        if (this.prefixes.isEmpty()) {
            throw new IllegalStateException();
        }
        String ns = this.prefixes.stream().map(m -> (String)m.get(prefix)).filter(Objects::nonNull).findFirst().orElse(null);
        if (ns != null) {
            if (!ns.equals(namespace)) {
                throw new XMLStreamException(String.format("Prefix <%s> is already bound to <%s>", namespace, ns));
            }
            return false;
        }
        this.prefixes.peek().put(prefix, namespace);
        return true;
    }

    public void startDocument() throws XMLStreamException {
        this.dispatch(this.eventFactory().createStartDocument(this.documentEncoding().name(), this.documentVersion()));
    }

    public void endDocument() throws XMLStreamException {
        this.dispatch(this.eventFactory().createEndDocument());
    }

    public void dispatch(XMLEvent event) throws XMLStreamException {
        if (event.isStartElement()) {
            this.prefixes.push(new HashMap(0));
        } else if (event.isEndElement()) {
            this.prefixes.pop();
        }
        this.writer.add(event);
    }

    @Override
    public void close() throws XMLStreamException {
        try (OutputStream s = this.stream;){
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public void flush() throws XMLStreamException {
        this.writer.flush();
    }
}

