/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode.stream.xml;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import org.n52.iceland.coding.decode.OwsDecodingException;
import org.n52.janmayen.http.MediaTypes;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.ows.service.OwsOperationKey;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.OperationDecoderKey;
import org.n52.svalbard.decode.XmlStringOperationDecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.stream.MissingStreamReaderException;
import org.n52.svalbard.decode.stream.StreamReader;
import org.n52.svalbard.decode.stream.StreamReaderRepository;
import org.n52.svalbard.decode.stream.xml.XmlStreamReaderKey;

public class XmlStreamingOperationDecoder
implements Decoder<Object, String> {
    private final QName name;
    private final OwsOperationKey operation;
    private final StreamReaderRepository streamReaderRepository;

    @Inject
    public XmlStreamingOperationDecoder(OwsOperationKey operation, QName name, StreamReaderRepository streamReaderRepository) {
        this.name = Objects.requireNonNull(name);
        this.operation = Objects.requireNonNull(operation);
        this.streamReaderRepository = Objects.requireNonNull(streamReaderRepository);
    }

    public Object decode(String string) throws DecodingException {
        XmlStreamReaderKey key = new XmlStreamReaderKey(this.name);
        StreamReader reader = this.streamReaderRepository.getReader(key).orElseThrow(() -> new MissingStreamReaderException(key));
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        try {
            return reader.read(new ByteArrayInputStream(bytes));
        }
        catch (OwsExceptionReport ex) {
            throw new OwsDecodingException(ex);
        }
    }

    public Set<DecoderKey> getKeys() {
        return new HashSet<OwsOperationKey>(Arrays.asList(new OperationDecoderKey(this.operation, MediaTypes.TEXT_XML), new OperationDecoderKey(this.operation, MediaTypes.APPLICATION_XML), new XmlStringOperationDecoderKey(this.operation, MediaTypes.APPLICATION_XML), new XmlStringOperationDecoderKey(this.operation, MediaTypes.TEXT_XML)));
    }
}

