/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.rest.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.n52.javaps.rest.model.Link;
import org.n52.javaps.rest.model.StatusEnum;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class StatusInfo {
    @JsonProperty(value="status")
    private StatusEnum status;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="progress")
    private Integer progress;
    @JsonProperty(value="jobID")
    private String jobID;
    @JsonProperty(value="links")
    @Valid
    private List<Link> links = new ArrayList<Link>();

    public StatusInfo status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @NotNull
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public StatusInfo message(String message) {
        this.message = message;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public StatusInfo progress(Integer progress) {
        this.progress = progress;
        return this;
    }

    @Min(value=0L)
    @Max(value=100L)
    public Integer getProgress() {
        return this.progress;
    }

    public void setProgress(Integer progress) {
        this.progress = progress;
    }

    public StatusInfo links(List<Link> links) {
        this.links = links;
        return this;
    }

    public StatusInfo addLinksItem(Link linksItem) {
        this.links.add(linksItem);
        return this;
    }

    public StatusInfo jobID(String jobID) {
        this.jobID = jobID;
        return this;
    }

    @NotNull
    public String getJobID() {
        return this.jobID;
    }

    public void setJobID(String jobID) {
        this.jobID = jobID;
    }

    @NotNull
    @Valid
    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusInfo statusInfo = (StatusInfo)o;
        return Objects.equals((Object)this.status, (Object)statusInfo.status) && Objects.equals(this.message, statusInfo.message) && Objects.equals(this.progress, statusInfo.progress) && Objects.equals(this.jobID, statusInfo.jobID) && Objects.equals(this.links, statusInfo.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.message, this.progress, this.jobID, this.links});
    }

    public String toString() {
        return String.format("StatusInfo{status: %s, message: %s, progress: %s, jobID: %s, links: %s}", new Object[]{this.status, this.message, this.progress, this.jobID, this.links});
    }
}

