/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.rest;

import java.net.URI;
import java.util.ArrayList;
import org.n52.faroe.Validation;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;
import org.n52.javaps.rest.LandingPageApi;
import org.n52.javaps.rest.model.LandingPage;
import org.n52.javaps.rest.model.Link;
import org.springframework.stereotype.Controller;

@Controller
@Configurable
public class LandingPageApiImpl
implements LandingPageApi {
    private String serviceURL;
    private String title;
    private String description;

    @Setting(value="service.serviceURL")
    public void setServiceURL(URI serviceURL) {
        Validation.notNull((String)"serviceURL", (Object)serviceURL);
        String url = serviceURL.toString();
        if (url.contains("?")) {
            url = url.split("[?]")[0];
        }
        this.serviceURL = url.replace("/service", "/rest");
    }

    @Setting(value="rest.title")
    public void setTitle(String title) {
        Validation.notNull((String)"title", (Object)title);
        this.title = title;
    }

    @Setting(value="rest.description")
    public void setDescription(String description) {
        Validation.notNull((String)"description", (Object)description);
        this.description = description;
    }

    @Override
    public LandingPage landingPage() {
        ArrayList<Link> links = new ArrayList<Link>();
        Link link = new Link();
        link.setHref(this.serviceURL);
        link.setRel("self");
        link.setType("application/json");
        link.setTitle("This document");
        links.add(link);
        link = new Link();
        link.setHref(this.serviceURL + "/api/");
        link.setRel("service");
        link.setType("application/openapi+json;version=3.0");
        link.setTitle("The API definition");
        links.add(link);
        link = new Link();
        link.setHref(this.serviceURL + "/conformance/");
        link.setRel("conformance");
        link.setType("application/json");
        link.setTitle("Conformance classes implemented by this server");
        links.add(link);
        link = new Link();
        link.setHref(this.serviceURL + "/processes/");
        link.setRel("processes");
        link.setType("application/json");
        link.setTitle("The processes offered by this server");
        links.add(link);
        return new LandingPage().title(this.title).description(this.description).links(links);
    }
}

