/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.rest;

import javax.validation.Valid;
import org.n52.javaps.algorithm.ExecutionException;
import org.n52.javaps.engine.EngineException;
import org.n52.javaps.engine.ProcessNotFoundException;
import org.n52.javaps.rest.model.Execute;
import org.n52.javaps.rest.model.Process;
import org.n52.javaps.rest.model.ProcessCollection;
import org.n52.javaps.rest.model.StatusInfo;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

public interface ProcessesApi {
    public static final String BASE_URL = "/rest/processes";

    @PostMapping(value={"/rest/processes/{processId}/jobs"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<?> execute(@Valid @RequestBody Execute var1, @PathVariable(value="processId") String var2) throws EngineException, ExecutionException;

    @GetMapping(value={"/rest/processes/{processId}/jobs"}, produces={"application/json"})
    public ResponseEntity<?> getJobList(@PathVariable(value="processId") String var1);

    @GetMapping(value={"/rest/processes/{processId}/jobs"}, produces={"text/html"})
    public String getExecuteForm(@PathVariable(value="processId") String var1, Model var2);

    @GetMapping(value={"/rest/processes/{processId:.+}"}, produces={"application/json"})
    @ResponseBody
    public Process getProcessDescription(@PathVariable(value="processId") String var1) throws ProcessNotFoundException;

    @GetMapping(value={"/rest/processes"}, produces={"application/json"})
    @ResponseBody
    public ProcessCollection getProcesses();

    @GetMapping(value={"/rest/processes/{processId}/jobs/{jobId}/results"}, produces={"application/json"})
    public ResponseEntity<?> getResult(@PathVariable(value="processId") String var1, @PathVariable(value="jobId") String var2) throws EngineException, ExecutionException;

    @GetMapping(value={"/rest/processes/{processId}/jobs/{jobId}"}, produces={"application/json"})
    @ResponseBody
    public StatusInfo getStatus(@PathVariable(value="processId") String var1, @PathVariable(value="jobId") String var2) throws EngineException;
}

