/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.rest;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.n52.javaps.engine.Engine;
import org.n52.javaps.engine.EngineException;
import org.n52.javaps.engine.JobNotFoundException;
import org.n52.javaps.engine.OutputNotFoundException;
import org.n52.javaps.engine.ProcessNotFoundException;
import org.n52.javaps.rest.ProcessesApiExtension;
import org.n52.shetland.ogc.ows.OwsCode;
import org.n52.shetland.ogc.wps.JobId;
import org.n52.shetland.ogc.wps.Result;
import org.n52.shetland.ogc.wps.data.ProcessData;
import org.n52.shetland.ogc.wps.data.ValueProcessData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;

@Controller
public final class ProcessesApiExtensionImpl
implements ProcessesApiExtension {
    private final Engine engine;

    @Autowired
    private ProcessesApiExtensionImpl(Engine engine) {
        this.engine = Objects.requireNonNull(engine);
    }

    @Override
    public ResponseEntity<?> getOutput(String processID, String jobID, String outputID) throws EngineException {
        JobId jobId = new JobId(jobID);
        OwsCode processId = new OwsCode(processID);
        OwsCode outputId = new OwsCode(outputID);
        if (!this.engine.hasProcessDescription(processId)) {
            throw new ProcessNotFoundException(processId);
        }
        if (!this.engine.hasJob(jobId)) {
            throw new JobNotFoundException(jobId);
        }
        try {
            Future future = this.engine.getResult(jobId);
            if (!future.isDone()) {
                throw new OutputNotFoundException();
            }
            ProcessData output = ((Result)future.get()).getOutputs().stream().filter(x -> x.getId().equals((Object)outputId)).findFirst().orElseThrow(OutputNotFoundException::new);
            return this.getResponseEntity(output);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new OutputNotFoundException((Throwable)e);
        }
    }

    private ResponseEntity<?> getResponseEntity(ProcessData output) throws EngineException {
        if (output.isReference()) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(output.asReference().getURI())).build();
        }
        if (output.isGroup()) {
            throw new EngineException("Grouped outputs are not supported");
        }
        if (output.isValue()) {
            byte[] value;
            ValueProcessData valueProcessData = output.asValue();
            try (InputStream data = valueProcessData.getData();
                 ByteArrayOutputStream out = new ByteArrayOutputStream();){
                ByteStreams.copy((InputStream)data, (OutputStream)out);
                value = out.toByteArray();
            }
            catch (IOException ex) {
                throw new EngineException((Throwable)ex);
            }
            ByteArrayResource inputStreamResource = new ByteArrayResource(value);
            ResponseEntity.BodyBuilder builder = ResponseEntity.ok();
            valueProcessData.getFormat().getMimeType().map(MediaType::valueOf).ifPresent(arg_0 -> ((ResponseEntity.BodyBuilder)builder).contentType(arg_0));
            return builder.contentLength((long)value.length).body((Object)inputStreamResource);
        }
        throw new EngineException("Unsupported output type " + output);
    }
}

