/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.rest;

import java.util.Objects;
import org.n52.javaps.algorithm.ExecutionException;
import org.n52.javaps.engine.EngineException;
import org.n52.javaps.engine.InputDecodingException;
import org.n52.javaps.engine.JobNotFoundException;
import org.n52.javaps.engine.OutputEncodingException;
import org.n52.javaps.engine.OutputNotFoundException;
import org.n52.javaps.engine.ProcessNotFoundException;
import org.n52.javaps.engine.UnsupportedInputFormatException;
import org.n52.javaps.engine.UnsupportedOutputFormatException;
import org.n52.javaps.rest.Api;
import org.n52.javaps.rest.ConformanceApi;
import org.n52.javaps.rest.LandingPageApi;
import org.n52.javaps.rest.ProcessesApi;
import org.n52.javaps.rest.ProcessesApiExtension;
import org.n52.javaps.rest.model.Exception;
import org.n52.javaps.rest.serializer.ExceptionSerializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice(assignableTypes={Api.class, LandingPageApi.class, ConformanceApi.class, ProcessesApi.class, ProcessesApiExtension.class})
@RequestMapping(produces={"application/json"})
public class EngineExceptionAdvice {
    protected static final String INVALID_PARAMETER = "InvalidParameter";
    protected static final String NO_APPLICABLE_CODE = "NoApplicableCode";
    private final ExceptionSerializer exceptionSerializer;

    @Autowired
    public EngineExceptionAdvice(ExceptionSerializer exceptionSerializer) {
        this.exceptionSerializer = Objects.requireNonNull(exceptionSerializer);
    }

    protected ExceptionSerializer getExceptionSerializer() {
        return this.exceptionSerializer;
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={JobNotFoundException.class})
    public Exception handle(JobNotFoundException ex) {
        return this.getExceptionSerializer().serializeException(INVALID_PARAMETER, ex.getMessage());
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={ProcessNotFoundException.class})
    public Exception handle(ProcessNotFoundException ex) {
        return this.getExceptionSerializer().serializeException(INVALID_PARAMETER, ex.getMessage());
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={OutputNotFoundException.class})
    public Exception handle(OutputNotFoundException ex) {
        return this.getExceptionSerializer().serializeException(INVALID_PARAMETER, ex.getMessage());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={InputDecodingException.class})
    public Exception handle(InputDecodingException ex) {
        return this.getExceptionSerializer().serializeException(INVALID_PARAMETER, ex.getMessage());
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={OutputEncodingException.class})
    public Exception handle(OutputEncodingException ex) {
        return this.getExceptionSerializer().serializeException(INVALID_PARAMETER, ex.getMessage());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={UnsupportedInputFormatException.class})
    public Exception handle(UnsupportedInputFormatException ex) {
        return this.getExceptionSerializer().serializeException(INVALID_PARAMETER, ex.getMessage());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={UnsupportedOutputFormatException.class})
    public Exception handle(UnsupportedOutputFormatException ex) {
        return this.getExceptionSerializer().serializeException(INVALID_PARAMETER, ex.getMessage());
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={EngineException.class})
    public Exception handle(EngineException ex) {
        return this.getExceptionSerializer().serializeException(NO_APPLICABLE_CODE, ex.getMessage());
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={java.lang.Exception.class})
    public Exception handle(java.lang.Exception ex) {
        return this.getExceptionSerializer().serializeException(NO_APPLICABLE_CODE, ex.getMessage());
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={ExecutionException.class})
    public Exception handle(ExecutionException ex) {
        return this.getExceptionSerializer().serializeException(NO_APPLICABLE_CODE, ex.getMessage());
    }
}

