/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.rest;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JacksonConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public JsonNodeFactory jsonNodeFactory() {
        return JsonNodeFactory.withExactBigDecimals((boolean)false);
    }

    @Bean
    @ConditionalOnMissingBean
    public ObjectReader objectReader(ObjectMapper objectMapper) {
        return objectMapper.reader();
    }

    @Bean
    @ConditionalOnMissingBean
    public ObjectWriter objectWriter(ObjectMapper objectMapper) {
        DefaultPrettyPrinter pp = new DefaultPrettyPrinter();
        pp.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        return objectMapper.writer((PrettyPrinter)pp);
    }

    @Bean
    @ConditionalOnMissingBean
    public ObjectMapper objectMapper(JsonNodeFactory jsonNodeFactory) {
        return new ObjectMapper().setNodeFactory(jsonNodeFactory).enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
    }
}

