/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.rest;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.n52.faroe.Validation;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;
import org.n52.javaps.engine.Engine;
import org.n52.javaps.engine.EngineException;
import org.n52.javaps.engine.JobNotFoundException;
import org.n52.javaps.engine.ProcessNotFoundException;
import org.n52.javaps.rest.ProcessesApi;
import org.n52.javaps.rest.deserializer.ExecuteDeserializer;
import org.n52.javaps.rest.model.Execute;
import org.n52.javaps.rest.model.JobCollection;
import org.n52.javaps.rest.model.JobInfo;
import org.n52.javaps.rest.model.Process;
import org.n52.javaps.rest.model.ProcessCollection;
import org.n52.javaps.rest.model.StatusInfo;
import org.n52.javaps.rest.serializer.ExceptionSerializer;
import org.n52.javaps.rest.serializer.ProcessSerializer;
import org.n52.javaps.rest.serializer.ResultSerializer;
import org.n52.javaps.rest.serializer.StatusInfoSerializer;
import org.n52.shetland.ogc.ows.OwsCode;
import org.n52.shetland.ogc.wps.JobId;
import org.n52.shetland.ogc.wps.OutputDefinition;
import org.n52.shetland.ogc.wps.ProcessOffering;
import org.n52.shetland.ogc.wps.ResponseMode;
import org.n52.shetland.ogc.wps.Result;
import org.n52.shetland.ogc.wps.data.ProcessData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;

@Controller
@Configurable
public final class ProcessesApiImpl
implements ProcessesApi {
    private static final Logger log = LoggerFactory.getLogger(ProcessesApiImpl.class);
    private Engine engine;
    private String serviceURL;
    private boolean isJobListEnabled;
    private ServletContext context;
    private HttpServletRequest request;
    private ProcessSerializer processSerializer;
    private StatusInfoSerializer statusInfoSerializer;
    private ExceptionSerializer exceptionSerializer;
    private ResultSerializer resultSerializer;
    private ExecuteDeserializer executeDeserializer;

    @Autowired
    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    @Autowired
    public void setContext(ServletContext context) {
        this.context = context;
    }

    @Autowired
    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    @Autowired
    public void setExceptionSerializer(ExceptionSerializer exceptionSerializer) {
        this.exceptionSerializer = exceptionSerializer;
    }

    @Autowired
    public void setProcessSerializer(ProcessSerializer processSerializer) {
        this.processSerializer = processSerializer;
    }

    @Autowired
    public void setExecuteDeserializer(ExecuteDeserializer executeDeserializer) {
        this.executeDeserializer = executeDeserializer;
    }

    @Autowired
    public void setResultSerializer(ResultSerializer resultSerializer) {
        this.resultSerializer = resultSerializer;
    }

    @Autowired
    public void setStatusInfoSerializer(StatusInfoSerializer statusInfoSerializer) {
        this.statusInfoSerializer = statusInfoSerializer;
    }

    @Setting(value="service.serviceURL")
    public void setServiceURL(URI serviceURL) {
        Validation.notNull((String)"serviceURL", (Object)serviceURL);
        String url = serviceURL.toString();
        if (url.contains("?")) {
            url = url.split("[?]")[0];
        }
        this.serviceURL = url.replace("/service", "/rest/processes");
    }

    @ExceptionHandler(value={RuntimeException.class})
    public ResponseEntity<?> handleException(RuntimeException e) {
        String msg = String.format("Runtime exception during request processing: %s", e.getMessage());
        log.error(msg, (Throwable)e);
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.exceptionSerializer.serializeException("ExecutionError", msg));
    }

    @Setting(value="rest.enable.joblist.extension")
    public void setIsJobListEnabled(Boolean isJobListEnabled) {
        Validation.notNull((String)"isJobListEnabled", (Object)isJobListEnabled);
        this.isJobListEnabled = isJobListEnabled;
    }

    @Override
    public ResponseEntity<?> execute(Execute body, String id) throws EngineException, org.n52.javaps.algorithm.ExecutionException {
        boolean syncExecute = false;
        try {
            syncExecute = body.getMode().equals((Object)Execute.ModeEnum.SYNC);
        }
        catch (Exception e) {
            log.error("Could not resolve execution mode: ", (Throwable)e);
        }
        ResponseMode responseMode = ResponseMode.DOCUMENT;
        try {
            if (body.getResponse().equals((Object)Execute.ResponseEnum.RAW)) {
                responseMode = ResponseMode.RAW;
            }
        }
        catch (Exception e) {
            log.error("Could not resolve response mode. Falling back to DOCUMENT", (Throwable)e);
        }
        OwsCode owsCode = new OwsCode(id);
        List<ProcessData> inputs = this.executeDeserializer.readInputs(body.getInputs());
        List<OutputDefinition> outputs = this.executeDeserializer.readOutputs(body.getOutputs());
        JobId jobId = this.engine.execute(owsCode, inputs, outputs, responseMode);
        if (syncExecute) {
            try {
                Future future = this.engine.getResult(jobId);
                Result result = (Result)future.get();
                String mimeType = "application/json";
                if (result.getResponseMode().equals((Object)ResponseMode.RAW)) {
                    mimeType = ((ProcessData)result.getOutputs().get(0)).asValue().getFormat().getMimeType().orElse("application/json");
                }
                HttpHeaders responseHeaders = new HttpHeaders();
                responseHeaders.setContentType(MediaType.parseMediaType((String)mimeType));
                ResponseEntity responseEntity = new ResponseEntity(this.resultSerializer.serializeResult(result), (MultiValueMap)responseHeaders, HttpStatus.OK);
                return responseEntity;
            }
            catch (InterruptedException e) {
                throw new EngineException((Throwable)e);
            }
            catch (ExecutionException e) {
                return this.handleExecutionException(e);
            }
        }
        String uri = String.format("%s/%s/jobs/%s", this.serviceURL, id, jobId.getValue());
        return ResponseEntity.created((URI)URI.create(uri)).build();
    }

    @Override
    public ResponseEntity<?> getJobList(String id) {
        if (!this.isJobListEnabled) {
            return ResponseEntity.status((int)501).build();
        }
        OwsCode owsCode = new OwsCode(id);
        Set values = this.engine.getJobIdentifiers(owsCode).stream().map(JobId::getValue).collect(Collectors.toSet());
        JobCollection jobCollection = new JobCollection();
        for (String jobID : values) {
            JobId jobId = new JobId(jobID);
            JobInfo jobsItem = new JobInfo();
            jobsItem.setId(jobID);
            try {
                org.n52.shetland.ogc.wps.StatusInfo status = this.engine.getStatus(jobId);
                jobsItem.setInfos(this.statusInfoSerializer.serialize(status, id, jobID, true));
            }
            catch (EngineException e) {
                log.error(e.getMessage());
            }
            jobCollection.add(jobsItem);
        }
        return ResponseEntity.ok((Object)jobCollection);
    }

    @Override
    public String getExecuteForm(String id, Model model) {
        OwsCode owsCode = new OwsCode(id);
        this.context.setAttribute("processId", (Object)id);
        Set jobSet = Collections.emptySet();
        if (this.isJobListEnabled) {
            jobSet = this.engine.getJobIdentifiers(owsCode).stream().map(JobId::getValue).collect(Collectors.toSet());
        }
        this.context.setAttribute("jobSet", jobSet);
        this.context.setAttribute("originalRequestURL", (Object)this.request.getRequestURL().toString());
        return "../../../jsp/test_client";
    }

    @Override
    public Process getProcessDescription(String id) throws ProcessNotFoundException {
        OwsCode owsCode = new OwsCode(id);
        return this.engine.getProcessDescription(owsCode).map(ProcessOffering::new).map(this.processSerializer::serializeProcessOffering).orElseThrow(() -> new ProcessNotFoundException(owsCode));
    }

    @Override
    public ProcessCollection getProcesses() {
        Set<ProcessOffering> offerings = this.engine.getProcessDescriptions().stream().map(ProcessOffering::new).collect(Collectors.toSet());
        return this.processSerializer.createProcessCollection(offerings);
    }

    @Override
    public ResponseEntity<?> getResult(String processID, String jobID) throws EngineException, org.n52.javaps.algorithm.ExecutionException {
        JobId jobId = new JobId(jobID);
        OwsCode processId = new OwsCode(processID);
        if (!this.engine.hasProcessDescription(processId)) {
            throw new ProcessNotFoundException(processId);
        }
        if (!this.engine.hasJob(jobId)) {
            throw new JobNotFoundException(jobId);
        }
        try {
            Future futureResult = this.engine.getResult(jobId);
            if (!futureResult.isDone()) {
                return ResponseEntity.badRequest().body((Object)this.exceptionSerializer.serializeException("ResultNotReady", String.format("Job with id %s not ready.", jobId)));
            }
            Result result = (Result)futureResult.get();
            String mimeType = "application/json";
            if (result.getResponseMode().equals((Object)ResponseMode.RAW)) {
                mimeType = ((ProcessData)result.getOutputs().get(0)).asValue().getFormat().getMimeType().orElse("application/json");
            }
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.setContentType(MediaType.parseMediaType((String)mimeType));
            ResponseEntity responseEntity = new ResponseEntity(this.resultSerializer.serializeResult(result), (MultiValueMap)responseHeaders, HttpStatus.OK);
            return responseEntity;
        }
        catch (InterruptedException e) {
            throw new EngineException((Throwable)e);
        }
        catch (ExecutionException e) {
            return this.handleExecutionException(e);
        }
    }

    private <T> ResponseEntity<T> handleExecutionException(ExecutionException e) throws org.n52.javaps.algorithm.ExecutionException, EngineException {
        if (e.getCause() instanceof EngineException) {
            if (e.getCause().getCause() instanceof org.n52.javaps.algorithm.ExecutionException) {
                throw (org.n52.javaps.algorithm.ExecutionException)e.getCause().getCause();
            }
            throw (EngineException)e.getCause();
        }
        if (e.getCause() instanceof org.n52.javaps.algorithm.ExecutionException) {
            throw (org.n52.javaps.algorithm.ExecutionException)e.getCause();
        }
        throw new EngineException((Throwable)e);
    }

    @Override
    public StatusInfo getStatus(String processId, String jobID) throws EngineException {
        OwsCode identifier = new OwsCode(processId);
        if (!this.engine.hasProcessDescription(identifier)) {
            throw new ProcessNotFoundException(identifier);
        }
        JobId jobId = new JobId(jobID);
        if (!this.engine.hasJob(jobId)) {
            throw new JobNotFoundException(jobId);
        }
        return this.statusInfoSerializer.serialize(this.engine.getStatus(jobId), processId, jobID, false);
    }
}

