/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.rest.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.n52.javaps.rest.model.Input;
import org.n52.javaps.rest.model.Output;
import org.springframework.validation.annotation.Validated;

@Validated
public class Execute {
    @JsonProperty(value="inputs")
    @Valid
    private List<Input> inputs;
    @JsonProperty(value="outputs")
    @Valid
    private List<Output> outputs = new ArrayList<Output>();
    @JsonProperty(value="mode")
    private ModeEnum mode;
    @JsonProperty(value="response")
    private ResponseEnum response;

    public Execute inputs(List<Input> inputs) {
        this.inputs = inputs;
        return this;
    }

    public Execute addInputsItem(Input inputsItem) {
        if (this.inputs == null) {
            this.inputs = new ArrayList<Input>();
        }
        this.inputs.add(inputsItem);
        return this;
    }

    public Execute mode(ModeEnum mode) {
        this.mode = mode;
        return this;
    }

    public Execute response(ResponseEnum response) {
        this.response = response;
        return this;
    }

    @Valid
    public List<Input> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<Input> inputs) {
        this.inputs = inputs;
    }

    public Execute outputs(List<Output> outputs) {
        this.outputs = outputs;
        return this;
    }

    public Execute addOutputsItem(Output outputsItem) {
        this.outputs.add(outputsItem);
        return this;
    }

    @NotNull
    @Valid
    public List<Output> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<Output> outputs) {
        this.outputs = outputs;
    }

    @NotNull
    public ModeEnum getMode() {
        return this.mode;
    }

    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    @NotNull
    public ResponseEnum getResponse() {
        return this.response;
    }

    public void setResponse(ResponseEnum response) {
        this.response = response;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Execute execute = (Execute)o;
        return Objects.equals(this.inputs, execute.inputs) && Objects.equals(this.outputs, execute.outputs) && Objects.equals((Object)this.mode, (Object)execute.mode) && Objects.equals((Object)this.response, (Object)execute.response);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.inputs, this.outputs, this.mode, this.response});
    }

    public String toString() {
        return String.format("Execute{inputs: %s, outputs: %s, mode: %s, response: %s}", new Object[]{this.inputs, this.outputs, this.mode, this.response});
    }

    public static enum ResponseEnum {
        RAW("raw"),
        DOCUMENT("document");

        private String value;

        private ResponseEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResponseEnum fromValue(String text) {
            for (ResponseEnum b : ResponseEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum ModeEnum {
        SYNC("sync"),
        ASYNC("async"),
        AUTO("auto");

        private String value;

        private ModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ModeEnum fromValue(String text) {
            for (ModeEnum b : ModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

