/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.n52.javaps.rest.model.InputDescription;
import org.n52.javaps.rest.model.Link;
import org.n52.javaps.rest.model.OutputDescription;
import org.n52.javaps.rest.model.ProcessSummary;
import org.springframework.validation.annotation.Validated;

@Validated
public class Process
extends ProcessSummary {
    @JsonProperty(value="inputs")
    @Valid
    private List<InputDescription> inputs;
    @JsonProperty(value="outputs")
    @Valid
    private List<OutputDescription> outputs;
    @JsonProperty(value="links")
    @Valid
    private List<Link> links;

    public Process inputs(List<InputDescription> inputs) {
        this.inputs = inputs;
        return this;
    }

    public Process outputs(List<OutputDescription> outputs) {
        this.outputs = outputs;
        return this;
    }

    @Override
    public Process links(List<Link> links) {
        this.links = links;
        return this;
    }

    @Valid
    public List<InputDescription> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<InputDescription> inputs) {
        this.inputs = inputs;
    }

    public Process addInputsItem(InputDescription inputsItem) {
        if (this.inputs == null) {
            this.inputs = new ArrayList<InputDescription>();
        }
        this.inputs.add(inputsItem);
        return this;
    }

    @Valid
    public List<OutputDescription> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<OutputDescription> outputs) {
        this.outputs = outputs;
    }

    public Process addOutputsItem(OutputDescription outputsItem) {
        if (this.outputs == null) {
            this.outputs = new ArrayList<OutputDescription>();
        }
        this.outputs.add(outputsItem);
        return this;
    }

    @Override
    @Valid
    public List<Link> getLinks() {
        return this.links;
    }

    @Override
    public void setLinks(List<Link> links) {
        this.links = links;
    }

    @Override
    public Process addLinksItem(Link linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<Link>();
        }
        this.links.add(linksItem);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Process process = (Process)o;
        return Objects.equals(this.inputs, process.inputs) && Objects.equals(this.outputs, process.outputs) && Objects.equals(this.links, process.links) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.inputs, this.outputs, this.links, super.hashCode());
    }

    @Override
    public String toString() {
        return String.format("Process{%s, inputs: %s, outputs: %s, links: %s}", super.toString(), this.inputs, this.outputs, this.links);
    }
}

