/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.rest.serializer;

import java.net.URI;
import org.n52.faroe.Validation;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;

@Configurable
public abstract class AbstractSerializer {
    private String serviceURL;

    @Setting(value="service.serviceURL")
    public void setServiceURL(URI serviceURL) {
        Validation.notNull((String)"serviceURL", (Object)serviceURL);
        String url = serviceURL.toString();
        if (url.contains("?")) {
            url = url.split("[?]")[0];
        }
        this.serviceURL = url.replace("/service", "/rest/processes");
    }

    protected String createJobHref(String processId, String jobId) {
        return String.format("%s/%s/jobs/%s", this.serviceURL, processId, jobId);
    }

    protected String createResultHref(String processId, String jobId) {
        return String.format("%s/%s/jobs/%s/results", this.serviceURL, processId, jobId);
    }

    protected String getJobsHref(String processId) {
        return String.format("%s/%s/jobs", this.serviceURL, processId);
    }

    protected String getProcessHref(String processId) {
        return String.format("%s/%s", this.serviceURL, processId);
    }
}

