/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.rest.serializer;

import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.n52.faroe.annotation.Configurable;
import org.n52.javaps.rest.model.AllowedValues;
import org.n52.javaps.rest.model.AnyValue;
import org.n52.javaps.rest.model.BoundingBoxDataType;
import org.n52.javaps.rest.model.ComplexDataType;
import org.n52.javaps.rest.model.DescriptionType;
import org.n52.javaps.rest.model.FormatDescription;
import org.n52.javaps.rest.model.InputDescription;
import org.n52.javaps.rest.model.JobControlOptions;
import org.n52.javaps.rest.model.Link;
import org.n52.javaps.rest.model.LiteralDataDomain;
import org.n52.javaps.rest.model.LiteralDataType;
import org.n52.javaps.rest.model.Metadata;
import org.n52.javaps.rest.model.NameReferenceType;
import org.n52.javaps.rest.model.OutputDescription;
import org.n52.javaps.rest.model.Process;
import org.n52.javaps.rest.model.ProcessCollection;
import org.n52.javaps.rest.model.ProcessSummary;
import org.n52.javaps.rest.model.Range;
import org.n52.javaps.rest.model.SupportedCRS;
import org.n52.javaps.rest.model.TransmissionMode;
import org.n52.javaps.rest.model.ValueReference;
import org.n52.javaps.rest.serializer.AbstractSerializer;
import org.n52.shetland.ogc.ows.OwsAllowedValues;
import org.n52.shetland.ogc.ows.OwsCRS;
import org.n52.shetland.ogc.ows.OwsDomainMetadata;
import org.n52.shetland.ogc.ows.OwsKeyword;
import org.n52.shetland.ogc.ows.OwsLanguageString;
import org.n52.shetland.ogc.ows.OwsMetadata;
import org.n52.shetland.ogc.ows.OwsPossibleValues;
import org.n52.shetland.ogc.ows.OwsRange;
import org.n52.shetland.ogc.ows.OwsValue;
import org.n52.shetland.ogc.ows.OwsValueRestriction;
import org.n52.shetland.ogc.ows.OwsValuesReference;
import org.n52.shetland.ogc.wps.DataTransmissionMode;
import org.n52.shetland.ogc.wps.Format;
import org.n52.shetland.ogc.wps.JobControlOption;
import org.n52.shetland.ogc.wps.ProcessOffering;
import org.n52.shetland.ogc.wps.description.BoundingBoxDescription;
import org.n52.shetland.ogc.wps.description.BoundingBoxInputDescription;
import org.n52.shetland.ogc.wps.description.BoundingBoxOutputDescription;
import org.n52.shetland.ogc.wps.description.ComplexDescription;
import org.n52.shetland.ogc.wps.description.ComplexInputDescription;
import org.n52.shetland.ogc.wps.description.ComplexOutputDescription;
import org.n52.shetland.ogc.wps.description.Description;
import org.n52.shetland.ogc.wps.description.LiteralDescription;
import org.n52.shetland.ogc.wps.description.LiteralInputDescription;
import org.n52.shetland.ogc.wps.description.LiteralOutputDescription;
import org.n52.shetland.ogc.wps.description.ProcessInputDescription;
import org.n52.shetland.ogc.wps.description.ProcessOutputDescription;
import org.springframework.stereotype.Component;

@Configurable
@Component
public class ProcessSerializer
extends AbstractSerializer {
    public Process serializeProcessOffering(ProcessOffering processOffering) {
        Process process = this.createProcessSummary(processOffering, Process::new);
        process.setLinks(Collections.singletonList(this.createExecuteLink(process)));
        process.setInputs(this.createInputDescriptions(processOffering.getProcessDescription().getInputDescriptions()));
        process.setOutputs(this.createOutputDescriptions(processOffering.getProcessDescription().getOutputDescriptions()));
        return process;
    }

    private <T extends ProcessSummary> T createProcessSummary(ProcessOffering processOffering, Supplier<T> factory) {
        ProcessSummary processSummary = (ProcessSummary)this.createDescription((Description)processOffering.getProcessDescription(), factory);
        processOffering.getProcessVersion().ifPresent(processSummary::setVersion);
        processSummary.setJobControlOptions(this.createJobControlOptions(processOffering));
        processSummary.setOutputTransmission(this.createOutputTransmissionModes(processOffering));
        return (T)processSummary;
    }

    private ProcessSummary createProcessSummary(ProcessOffering processOffering) {
        ProcessSummary process = this.createProcessSummary(processOffering, ProcessSummary::new);
        process.links(Collections.singletonList(this.getProcessLink(process)));
        return process;
    }

    private List<TransmissionMode> createOutputTransmissionModes(ProcessOffering processOffering) {
        return processOffering.getOutputTransmissionModes().stream().map(this::createDataTransmissionMode).collect(Collectors.toList());
    }

    private TransmissionMode createDataTransmissionMode(DataTransmissionMode outputTransmissionMode) {
        switch (outputTransmissionMode) {
            case VALUE: {
                return TransmissionMode.VALUE;
            }
            case REFERENCE: {
                return TransmissionMode.REFERENCE;
            }
        }
        throw new IllegalArgumentException("unsupported data transmission mode" + outputTransmissionMode);
    }

    private List<JobControlOptions> createJobControlOptions(ProcessOffering processOffering) {
        return processOffering.getJobControlOptions().stream().map(this::createJobControlOption).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private JobControlOptions createJobControlOption(JobControlOption jobControlOption) {
        if (jobControlOption.equals((Object)JobControlOption.async())) {
            return JobControlOptions.ASYNC_EXECUTE;
        }
        if (jobControlOption.equals((Object)JobControlOption.sync())) {
            return JobControlOptions.SYNC_EXECUTE;
        }
        return null;
    }

    private <T extends DescriptionType> T createDescription(Description description, Supplier<T> factory) {
        DescriptionType descriptionType = (DescriptionType)factory.get();
        descriptionType.setId(description.getId().getValue());
        descriptionType.setTitle(description.getTitle().getValue());
        List<String> keywords = description.getKeywords().stream().map(OwsKeyword::getKeyword).map(OwsLanguageString::getValue).collect(Collectors.toList());
        descriptionType.setKeywords(keywords);
        description.getAbstract().map(OwsLanguageString::getValue).ifPresent(descriptionType::setDescription);
        description.getAbstract().map(OwsLanguageString::getValue).ifPresent(descriptionType::setDescription);
        descriptionType.setMetadata(description.getMetadata().stream().map(this::createMetadata).collect(Collectors.toList()));
        return (T)descriptionType;
    }

    private Metadata createMetadata(OwsMetadata x) {
        Metadata metadata = new Metadata();
        x.getRole().map(URI::toString).ifPresent(metadata::setRole);
        x.getHref().map(URI::toString).ifPresent(metadata::setHref);
        return metadata;
    }

    private List<OutputDescription> createOutputDescriptions(Collection<? extends ProcessOutputDescription> descriptions) {
        return descriptions.stream().map(this::createProcessOutputDescription).collect(Collectors.toList());
    }

    private OutputDescription createProcessOutputDescription(ProcessOutputDescription processOutputDescription) {
        OutputDescription outputDescription = this.createDescription((Description)processOutputDescription, OutputDescription::new);
        if (processOutputDescription.isComplex()) {
            outputDescription.setOutput(this.createComplexOutput(processOutputDescription.asComplex()));
        } else if (processOutputDescription.isLiteral()) {
            outputDescription.setOutput(this.createLiteralOutput(processOutputDescription.asLiteral()));
        } else if (processOutputDescription.isBoundingBox()) {
            outputDescription.setOutput(this.createBoundingBoxOutput(processOutputDescription.asBoundingBox()));
        }
        return outputDescription;
    }

    private BoundingBoxDataType createBoundingBoxOutput(BoundingBoxOutputDescription description) {
        return new BoundingBoxDataType().supportedCRS(this.createSupportedCRS((BoundingBoxDescription)description));
    }

    private LiteralDataType createLiteralOutput(LiteralOutputDescription description) {
        return new LiteralDataType().literalDataDomains(this.createLiteralDataDomains((LiteralDescription)description));
    }

    private ComplexDataType createComplexOutput(ComplexOutputDescription description) {
        return new ComplexDataType().formats(this.createFormats((ComplexDescription)description));
    }

    private List<LiteralDataDomain> createLiteralDataDomains(LiteralDescription description) {
        return Stream.concat(Stream.of(description.getDefaultLiteralDataDomain()), description.getSupportedLiteralDataDomains().stream()).map(this::createLiteralDataDomain).collect(Collectors.toList());
    }

    private List<InputDescription> createInputDescriptions(Collection<? extends ProcessInputDescription> descriptions) {
        return descriptions.stream().map(this::createInputDescription).collect(Collectors.toList());
    }

    private InputDescription createInputDescription(ProcessInputDescription processInputDescription) {
        InputDescription inputDescription = this.createDescription((Description)processInputDescription, InputDescription::new);
        inputDescription.setMinOccurs(processInputDescription.getOccurence().getMin());
        processInputDescription.getOccurence().getMax().ifPresent(inputDescription::setMaxOccurs);
        if (processInputDescription.isComplex()) {
            inputDescription.setInput(this.createComplexInput(processInputDescription.asComplex()));
        } else if (processInputDescription.isLiteral()) {
            inputDescription.setInput(this.createLiteralInput(processInputDescription.asLiteral()));
        } else if (processInputDescription.isBoundingBox()) {
            inputDescription.setInput(this.createBoundingBoxInput(processInputDescription.asBoundingBox()));
        } else if (processInputDescription.isGroup()) {
            throw new IllegalArgumentException("group inputs are not supported");
        }
        return inputDescription;
    }

    private BoundingBoxDataType createBoundingBoxInput(BoundingBoxInputDescription description) {
        return new BoundingBoxDataType().supportedCRS(this.createSupportedCRS((BoundingBoxDescription)description));
    }

    private LiteralDataType createLiteralInput(LiteralInputDescription description) {
        return new LiteralDataType().literalDataDomains(this.createLiteralDataDomains((LiteralDescription)description));
    }

    private ComplexDataType createComplexInput(ComplexInputDescription description) {
        return new ComplexDataType().formats(this.createFormats((ComplexDescription)description));
    }

    private List<SupportedCRS> createSupportedCRS(BoundingBoxDescription description) {
        List<SupportedCRS> serializedSupportedCRS = Stream.concat(Stream.of(description.getDefaultCRS()), description.getSupportedCRS().stream()).map(OwsCRS::getValue).map(URI::toString).map(x -> new SupportedCRS().crs((String)x)).collect(Collectors.toList());
        ((SupportedCRS)serializedSupportedCRS.get(0)).setDefault(true);
        return serializedSupportedCRS;
    }

    private LiteralDataDomain createLiteralDataDomain(org.n52.shetland.ogc.wps.description.LiteralDataDomain defaultLiteralDataDomain) {
        LiteralDataDomain literalDataDomain = new LiteralDataDomain();
        literalDataDomain.setDataType(this.createLiteralDataDomainDataType(defaultLiteralDataDomain));
        literalDataDomain.setValueDefinition(this.createPossibleValues(defaultLiteralDataDomain.getPossibleValues()));
        literalDataDomain.setUom(this.createUom(defaultLiteralDataDomain.getUOM()));
        defaultLiteralDataDomain.getDefaultValue().map(OwsValue::getValue).ifPresent(literalDataDomain::setDefaultValue);
        return literalDataDomain;
    }

    private NameReferenceType createUom(Optional<OwsDomainMetadata> uom) {
        NameReferenceType uomNameReferenceType = null;
        if (uom.isPresent()) {
            Optional referenceOptional;
            uomNameReferenceType = new NameReferenceType();
            OwsDomainMetadata owsDomainMetadata = uom.get();
            Optional valueOptional = owsDomainMetadata.getValue();
            if (valueOptional.isPresent()) {
                uomNameReferenceType.setName((String)valueOptional.get());
            }
            if ((referenceOptional = owsDomainMetadata.getReference()).isPresent()) {
                uomNameReferenceType.setReference(((URI)referenceOptional.get()).toString());
            }
        }
        return uomNameReferenceType;
    }

    private NameReferenceType createLiteralDataDomainDataType(org.n52.shetland.ogc.wps.description.LiteralDataDomain literalDataDomain) {
        NameReferenceType literalDataDomainDataType = new NameReferenceType();
        Optional dataType = literalDataDomain.getDataType();
        dataType.flatMap(OwsDomainMetadata::getValue).ifPresent(literalDataDomainDataType::setName);
        dataType.flatMap(OwsDomainMetadata::getReference).map(URI::toString).ifPresent(literalDataDomainDataType::setReference);
        return literalDataDomainDataType;
    }

    private Object createPossibleValues(OwsPossibleValues possibleValues) {
        if (possibleValues.isAnyValue()) {
            return new AnyValue().anyValue(true);
        }
        if (possibleValues.isAllowedValues()) {
            return this.createAllowedValues(possibleValues.asAllowedValues());
        }
        if (possibleValues.isValuesReference()) {
            return this.createValuesReference(possibleValues.asValuesReference());
        }
        throw new IllegalArgumentException("unsupported possible values: " + possibleValues);
    }

    private Object createValuesReference(OwsValuesReference valuesReference) {
        return new ValueReference().valueReference(valuesReference.getReference().toString());
    }

    private AllowedValues createAllowedValues(OwsAllowedValues allowedValues) {
        ArrayList<Object> allowedValuesList = new ArrayList<Object>();
        allowedValues.stream().map(this::createAllowedValue).collect(Collectors.toCollection(() -> allowedValuesList));
        AllowedValues allowedValues2Serialize = new AllowedValues();
        allowedValues2Serialize.allowedValues(allowedValuesList);
        return allowedValues2Serialize;
    }

    private Object createAllowedValue(OwsValueRestriction allowedValue) {
        if (allowedValue.isValue()) {
            return allowedValue.asValue().getValue();
        }
        if (allowedValue.isRange()) {
            return this.createRange(allowedValue.asRange());
        }
        throw new IllegalArgumentException("unsupported allowed value " + allowedValue);
    }

    private Range createRange(OwsRange owsRange) {
        Range range = new Range();
        owsRange.getLowerBound().map(OwsValue::getValue).ifPresent(range::setMinimumValue);
        owsRange.getUpperBound().map(OwsValue::getValue).ifPresent(range::setMaximumValue);
        owsRange.getSpacing().map(OwsValue::getValue).ifPresent(range::setSpacing);
        range.setRangeClosure(this.getRangeClosure(owsRange));
        return range;
    }

    private Range.RangeClosureEnum getRangeClosure(OwsRange range) {
        switch (range.getLowerBoundType()) {
            case CLOSED: {
                switch (range.getUpperBoundType()) {
                    case CLOSED: {
                        return Range.RangeClosureEnum.CLOSED;
                    }
                    case OPEN: {
                        return Range.RangeClosureEnum.CLOSED_OPEN;
                    }
                }
                throw this.unsupportedBoundType(range.getUpperBoundType());
            }
            case OPEN: {
                switch (range.getUpperBoundType()) {
                    case CLOSED: {
                        return Range.RangeClosureEnum.OPEN_CLOSED;
                    }
                    case OPEN: {
                        return Range.RangeClosureEnum.OPEN;
                    }
                }
                throw this.unsupportedBoundType(range.getUpperBoundType());
            }
        }
        throw this.unsupportedBoundType(range.getLowerBoundType());
    }

    private IllegalArgumentException unsupportedBoundType(OwsRange.BoundType lowerBoundType) {
        return new IllegalArgumentException("unsupported bound type: " + lowerBoundType);
    }

    private List<FormatDescription> createFormats(ComplexDescription description) {
        List<FormatDescription> formats = Stream.concat(Stream.of(description.getDefaultFormat()), description.getSupportedFormats().stream()).map(format -> this.createFormat((Format)format, description.getMaximumMegabytes())).collect(Collectors.toList());
        ((FormatDescription)formats.get(0)).setDefault(true);
        return formats;
    }

    private FormatDescription createFormat(Format format, Optional<BigInteger> maximumMegabytes) {
        FormatDescription formatDescription = new FormatDescription();
        format.getMimeType().ifPresent(formatDescription::setMimeType);
        format.getSchema().ifPresent(formatDescription::setSchema);
        format.getEncoding().ifPresent(formatDescription::setEncoding);
        maximumMegabytes.ifPresent(formatDescription::setMaximumMegabytes);
        return formatDescription;
    }

    public ProcessCollection createProcessCollection(Set<ProcessOffering> offerings) {
        ProcessCollection collection = new ProcessCollection();
        offerings.stream().map(this::createProcessSummary).forEachOrdered(collection::add);
        return collection;
    }

    private Link createExecuteLink(ProcessSummary process) {
        Link executeEndpointLink = new Link();
        executeEndpointLink.setHref(this.getJobsHref(process.getId()));
        executeEndpointLink.setRel("execute");
        executeEndpointLink.setTitle("Execute endpoint");
        return executeEndpointLink;
    }

    private Link getProcessLink(ProcessSummary process) {
        Link link = new Link();
        link.setHref(this.getProcessHref(process.getId()));
        link.setType("application/json");
        link.setRel("process-desc");
        link.setTitle("Process description");
        return link;
    }
}

