/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.rest.serializer;

import java.util.ArrayList;
import org.n52.faroe.annotation.Configurable;
import org.n52.javaps.rest.model.Link;
import org.n52.javaps.rest.model.StatusEnum;
import org.n52.javaps.rest.model.StatusInfo;
import org.n52.javaps.rest.serializer.AbstractSerializer;
import org.n52.shetland.ogc.wps.JobStatus;
import org.springframework.stereotype.Component;

@Component
@Configurable
public class StatusInfoSerializer
extends AbstractSerializer {
    public StatusInfo serialize(org.n52.shetland.ogc.wps.StatusInfo statusInfo, String processId, String jobId, boolean isList) {
        StatusInfo serializedStatusInfo = new StatusInfo();
        serializedStatusInfo.setJobID(jobId);
        serializedStatusInfo.setStatus(this.createStatusEnum(statusInfo.getStatus()));
        statusInfo.getPercentCompleted().map(Integer::valueOf).ifPresent(serializedStatusInfo::setProgress);
        ArrayList<Link> links = new ArrayList<Link>(2);
        if (isList) {
            links.add(this.createStatusLink(processId, jobId));
        } else {
            links.add(this.createSelfLink(processId, jobId));
        }
        if (statusInfo.getStatus().equals((Object)JobStatus.succeeded())) {
            links.add(this.createResultLink(processId, jobId));
        } else if (statusInfo.getStatus().equals((Object)JobStatus.failed())) {
            links.add(this.createExceptionLink(processId, jobId));
        }
        serializedStatusInfo.setLinks(links);
        return serializedStatusInfo;
    }

    private Link createSelfLink(String processId, String jobId) {
        Link selfLink = new Link();
        selfLink.setHref(this.createJobHref(processId, jobId));
        selfLink.setRel("self");
        selfLink.setType("application/json");
        selfLink.setTitle("This document");
        return selfLink;
    }

    private Link createStatusLink(String processId, String jobId) {
        Link selfLink = new Link();
        selfLink.setHref(this.createJobHref(processId, jobId));
        selfLink.setRel("status");
        selfLink.setType("application/json");
        selfLink.setTitle("Status document");
        return selfLink;
    }

    private Link createResultLink(String processId, String jobId) {
        Link resultLink = new Link();
        resultLink.setHref(this.createResultHref(processId, jobId));
        resultLink.setRel("results");
        resultLink.setType("application/json");
        resultLink.setTitle("Job results");
        return resultLink;
    }

    private Link createExceptionLink(String processId, String jobId) {
        Link exceptionLink = new Link();
        exceptionLink.setHref(this.createResultHref(processId, jobId));
        exceptionLink.setRel("exceptions");
        exceptionLink.setType("application/json");
        exceptionLink.setTitle("Job exceptions");
        return exceptionLink;
    }

    private StatusEnum createStatusEnum(JobStatus status) {
        if (status.equals((Object)JobStatus.succeeded())) {
            return StatusEnum.SUCCESSFUL;
        }
        if (status.equals((Object)JobStatus.failed())) {
            return StatusEnum.FAILED;
        }
        if (status.equals((Object)JobStatus.accepted())) {
            return StatusEnum.ACCEPTED;
        }
        if (status.equals((Object)JobStatus.running())) {
            return StatusEnum.RUNNING;
        }
        throw new IllegalArgumentException("Status not valid: " + status);
    }
}

