/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.service.handler;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.n52.iceland.request.handler.GenericOperationHandler;
import org.n52.iceland.request.handler.OperationHandlerKey;
import org.n52.javaps.engine.Engine;
import org.n52.javaps.service.handler.AbstractEngineHandler;
import org.n52.shetland.ogc.ows.OwsAllowedValues;
import org.n52.shetland.ogc.ows.OwsCode;
import org.n52.shetland.ogc.ows.OwsDomain;
import org.n52.shetland.ogc.ows.OwsPossibleValues;
import org.n52.shetland.ogc.ows.OwsValue;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.wps.ProcessOffering;
import org.n52.shetland.ogc.wps.ProcessOfferings;
import org.n52.shetland.ogc.wps.WPSConstants;
import org.n52.shetland.ogc.wps.request.DescribeProcessRequest;
import org.n52.shetland.ogc.wps.response.DescribeProcessResponse;

public class DescribeProcessHandler
extends AbstractEngineHandler
implements GenericOperationHandler<DescribeProcessRequest, DescribeProcessResponse> {
    private static final String IDENTIFIER = "Identifier";
    private static final OperationHandlerKey KEY = new OperationHandlerKey("WPS", (Enum)WPSConstants.Operations.DescribeProcess);

    @Inject
    public DescribeProcessHandler(Engine engine) {
        super(engine);
    }

    public DescribeProcessResponse handle(DescribeProcessRequest request) throws OwsExceptionReport {
        Set offerings = request.getProcessIdentifier().stream().map(arg_0 -> ((Engine)this.getEngine()).getProcessDescription(arg_0)).filter(Optional::isPresent).map(Optional::get).map(ProcessOffering::new).collect(Collectors.toSet());
        return new DescribeProcessResponse(request.getService(), request.getVersion(), new ProcessOfferings(offerings));
    }

    public String getOperationName() {
        return WPSConstants.Operations.DescribeProcess.toString();
    }

    public Set<OperationHandlerKey> getKeys() {
        return Collections.singleton(KEY);
    }

    protected Set<OwsDomain> getOperationParameters(String service, String version) {
        Stream<OwsValue> specialIdentifiers = Stream.of(new OwsValue("ALL"));
        Stream<OwsValue> algorithmIdentifiers = this.getEngine().getProcessIdentifiers().stream().map(OwsCode::getValue).map(OwsValue::new);
        OwsDomain identifierDomain = new OwsDomain(IDENTIFIER, (OwsPossibleValues)new OwsAllowedValues((Iterable)Stream.concat(specialIdentifiers, algorithmIdentifiers).collect(Collectors.toSet())));
        return Collections.singleton(identifierDomain);
    }

    public boolean isSupported() {
        return true;
    }
}

