/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.service.handler;

import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import org.n52.iceland.request.handler.GenericOperationHandler;
import org.n52.iceland.request.handler.OperationHandlerKey;
import org.n52.javaps.engine.Engine;
import org.n52.javaps.engine.JobNotFoundException;
import org.n52.javaps.service.handler.AbstractJobHandler;
import org.n52.shetland.ogc.ows.exception.InvalidParameterValueException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.wps.JobId;
import org.n52.shetland.ogc.wps.StatusInfo;
import org.n52.shetland.ogc.wps.WPSConstants;
import org.n52.shetland.ogc.wps.request.DismissRequest;
import org.n52.shetland.ogc.wps.response.DismissResponse;

public class DismissHandler
extends AbstractJobHandler
implements GenericOperationHandler<DismissRequest, DismissResponse> {
    private static final OperationHandlerKey KEY = new OperationHandlerKey("WPS", (Enum)WPSConstants.Operations.Dismiss);

    @Inject
    public DismissHandler(Engine engine) {
        super(engine, true);
    }

    public DismissResponse handle(DismissRequest request) throws OwsExceptionReport {
        StatusInfo status;
        JobId jobId = request.getJobId();
        try {
            status = this.getEngine().dismiss(jobId);
        }
        catch (JobNotFoundException ex) {
            throw new InvalidParameterValueException("JobId", jobId.getValue()).causedBy((Throwable)ex);
        }
        String service = request.getService();
        String version = request.getVersion();
        return new DismissResponse(service, version, status);
    }

    public String getOperationName() {
        return WPSConstants.Operations.Dismiss.toString();
    }

    public Set<OperationHandlerKey> getKeys() {
        return Collections.singleton(KEY);
    }

    public boolean isSupported() {
        return true;
    }
}

