/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.service.operator.validation;

import java.util.List;
import java.util.Optional;
import org.n52.javaps.service.operator.validation.EngineParameterValidator;
import org.n52.shetland.ogc.ows.OwsCode;
import org.n52.shetland.ogc.ows.exception.CompositeOwsException;
import org.n52.shetland.ogc.ows.exception.InvalidParameterValueException;
import org.n52.shetland.ogc.ows.exception.MissingParameterValueException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.wps.request.DescribeProcessRequest;

public class DescribeProcessParameterValidator
extends EngineParameterValidator<DescribeProcessRequest> {
    private static final String IDENTIFIER = "Identifier";

    public void validate(DescribeProcessRequest request) throws OwsExceptionReport {
        List identifiers = request.getProcessIdentifier();
        if (identifiers == null || identifiers.isEmpty()) {
            throw new MissingParameterValueException(IDENTIFIER);
        }
        this.checkIdentifiers(identifiers);
    }

    private void checkIdentifiers(List<OwsCode> identifiers) throws OwsExceptionReport {
        CompositeOwsException exception = new CompositeOwsException();
        identifiers.stream().map(this::checkIdentifier).filter(Optional::isPresent).map(Optional::get).forEach(xva$0 -> exception.add(new OwsExceptionReport[]{xva$0}));
        exception.throwIfNotEmpty();
    }

    private Optional<OwsExceptionReport> checkIdentifier(OwsCode id) {
        if (id == null) {
            return Optional.of(new MissingParameterValueException(IDENTIFIER));
        }
        if (!this.isAll(id) && !this.getEngine().hasProcessDescription(id)) {
            return Optional.of(new InvalidParameterValueException(IDENTIFIER, id.getValue()));
        }
        return Optional.empty();
    }

    private boolean isAll(OwsCode id) {
        return !id.getCodeSpace().isPresent() && id.getValue().equals("ALL");
    }
}

