/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.service.handler;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.n52.iceland.request.handler.GenericOperationHandler;
import org.n52.iceland.request.handler.OperationHandlerKey;
import org.n52.janmayen.http.MediaType;
import org.n52.javaps.engine.Engine;
import org.n52.javaps.engine.EngineException;
import org.n52.javaps.engine.InputDecodingException;
import org.n52.javaps.engine.JobNotFoundException;
import org.n52.javaps.engine.ProcessNotFoundException;
import org.n52.javaps.service.handler.AbstractEngineHandler;
import org.n52.shetland.ogc.ows.OwsAllowedValues;
import org.n52.shetland.ogc.ows.OwsCode;
import org.n52.shetland.ogc.ows.OwsDomain;
import org.n52.shetland.ogc.ows.OwsNoValues;
import org.n52.shetland.ogc.ows.OwsPossibleValues;
import org.n52.shetland.ogc.ows.OwsValue;
import org.n52.shetland.ogc.ows.exception.InvalidParameterValueException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.wps.ExecutionMode;
import org.n52.shetland.ogc.wps.JobId;
import org.n52.shetland.ogc.wps.ResponseMode;
import org.n52.shetland.ogc.wps.Result;
import org.n52.shetland.ogc.wps.StatusInfo;
import org.n52.shetland.ogc.wps.WPSConstants;
import org.n52.shetland.ogc.wps.data.ProcessData;
import org.n52.shetland.ogc.wps.request.ExecuteRequest;
import org.n52.shetland.ogc.wps.response.ExecuteResponse;

public class ExecuteHandler
extends AbstractEngineHandler
implements GenericOperationHandler<ExecuteRequest, ExecuteResponse> {
    private static final String IDENTIFIER = "Identifier";
    private static final OperationHandlerKey KEY = new OperationHandlerKey("WPS", (Enum)WPSConstants.Operations.Execute);

    @Inject
    public ExecuteHandler(Engine engine) {
        super(engine);
    }

    public ExecuteResponse handle(ExecuteRequest request) throws OwsExceptionReport {
        StatusInfo status;
        JobId jobId;
        String service = request.getService();
        String version = request.getVersion();
        try {
            jobId = this.getEngine().execute(request.getId(), request.getInputs(), request.getOutputs(), request.getResponseMode());
        }
        catch (ProcessNotFoundException ex) {
            throw new InvalidParameterValueException(IDENTIFIER, request.getId().getValue());
        }
        catch (InputDecodingException ex) {
            throw this.createNoApplicableCodeExceptionWithHttpStatusInternalServerError(ex);
        }
        if (request.getExecutionMode() == ExecutionMode.SYNC) {
            try {
                ProcessData data;
                Result result = (Result)this.getEngine().getResult(jobId).get();
                ExecuteResponse response = new ExecuteResponse(service, version, result);
                if (request.getResponseMode() == ResponseMode.RAW && (data = (ProcessData)((Result)response.getResult().get()).getOutputs().iterator().next()).isValue()) {
                    response.setContentType(data.asValue().getFormat().getMimeType().map(MediaType::parse).orElseGet(MediaType::new));
                }
                return response;
            }
            catch (InterruptedException | JobNotFoundException ex) {
                throw this.createNoApplicableCodeExceptionWithHttpStatusInternalServerError(ex);
            }
            catch (ExecutionException ex) {
                throw this.createNoApplicableCodeExceptionWithHttpStatusInternalServerError(ex.getCause());
            }
            catch (EngineException ex) {
                throw this.createNoApplicableCodeExceptionWithHttpStatusInternalServerError(ex);
            }
        }
        try {
            status = this.getEngine().getStatus(jobId);
        }
        catch (EngineException ex) {
            throw this.createNoApplicableCodeExceptionWithHttpStatusInternalServerError(ex);
        }
        return new ExecuteResponse(service, version, status);
    }

    public String getOperationName() {
        return WPSConstants.Operations.Execute.toString();
    }

    public Set<OperationHandlerKey> getKeys() {
        return Collections.singleton(KEY);
    }

    protected Set<OwsDomain> getOperationParameters(String service, String version) {
        Set algorithmIdentifiers = this.getEngine().getProcessIdentifiers().stream().map(OwsCode::getValue).map(OwsValue::new).collect(Collectors.toSet());
        Object possibleValues = algorithmIdentifiers.isEmpty() ? OwsNoValues.instance() : new OwsAllowedValues(algorithmIdentifiers);
        return Collections.singleton(new OwsDomain(IDENTIFIER, (OwsPossibleValues)possibleValues));
    }

    public boolean isSupported() {
        return true;
    }
}

