/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import org.n52.faroe.Validation;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;
import org.n52.janmayen.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Configurable
@Controller
@RequestMapping(value={"/info"})
public class InfoEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(InfoEndpoint.class);
    private static final String GIT_PROPERTIES_FILE = "/git.properties";
    private static final String VERSION_PROPERTIES_FILE = "/version.properties";
    private static final String TIME_PROPERTY = "git.build.time";
    private static final String COMMIT_PROPERTY = "git.commit.id";
    private static final String BRANCH_PROPERTY = "git.branch";
    private static final String VERSION_PROPERTY = "build.version";
    private static final String ENDPOINT = "endpoint";
    private static final String BRANCH = "branch";
    private static final String COMMIT = "commit";
    private static final String TIME = "time";
    private static final String VERSION = "version";
    private final String branch;
    private final String commit;
    private final String time;
    private final String version;
    private String serviceURL;

    public InfoEndpoint() {
        Properties gitProperties = InfoEndpoint.loadProperties(GIT_PROPERTIES_FILE);
        this.time = gitProperties.getProperty(TIME_PROPERTY);
        this.commit = gitProperties.getProperty(COMMIT_PROPERTY);
        this.branch = gitProperties.getProperty(BRANCH_PROPERTY);
        Properties versionProperties = InfoEndpoint.loadProperties(VERSION_PROPERTIES_FILE);
        this.version = versionProperties.getProperty(VERSION_PROPERTY);
        LOG.info("Created endpoint");
    }

    @Setting(value="service.serviceURL")
    public void setServiceURL(URI serviceURL) {
        Validation.notNull((String)"serviceURL", (Object)serviceURL);
        String url = serviceURL.toString();
        if (url.contains("?")) {
            url = url.split("[?]")[0];
        }
        this.serviceURL = url;
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    public String info() {
        return Json.print((JsonNode)Json.nodeFactory().objectNode().put(ENDPOINT, this.serviceURL).put(BRANCH, this.branch).put(COMMIT, this.commit).put(TIME, this.time).put(VERSION, this.version));
    }

    private static Properties loadProperties(String path) {
        URL url = Resources.getResource((String)path);
        ByteSource source = Resources.asByteSource((URL)url);
        Properties properties = new Properties();
        try (InputStream in = source.openStream();){
            LOG.info("Loading git properties from {}", (Object)url);
            properties.load(in);
        }
        catch (IOException e) {
            throw new Error("Could not load properties", e);
        }
        return properties;
    }
}

