/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.service.handler;

import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import org.n52.iceland.request.handler.GenericOperationHandler;
import org.n52.iceland.request.handler.OperationHandlerKey;
import org.n52.javaps.engine.Engine;
import org.n52.javaps.engine.EngineException;
import org.n52.javaps.engine.JobNotFoundException;
import org.n52.javaps.service.handler.AbstractJobHandler;
import org.n52.shetland.ogc.ows.exception.InvalidParameterValueException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.wps.JobId;
import org.n52.shetland.ogc.wps.StatusInfo;
import org.n52.shetland.ogc.wps.WPSConstants;
import org.n52.shetland.ogc.wps.request.GetStatusRequest;
import org.n52.shetland.ogc.wps.response.GetStatusResponse;

public class GetStatusHandler
extends AbstractJobHandler
implements GenericOperationHandler<GetStatusRequest, GetStatusResponse> {
    private static final OperationHandlerKey KEY = new OperationHandlerKey("WPS", (Enum)WPSConstants.Operations.GetStatus);

    @Inject
    public GetStatusHandler(Engine engine) {
        super(engine, true);
    }

    public GetStatusResponse handle(GetStatusRequest request) throws OwsExceptionReport {
        StatusInfo status;
        String service = request.getService();
        String version = request.getVersion();
        JobId jobId = request.getJobId();
        try {
            status = this.getEngine().getStatus(jobId);
        }
        catch (JobNotFoundException ex) {
            throw new InvalidParameterValueException("JobId", jobId.getValue()).causedBy((Throwable)ex);
        }
        catch (EngineException ex) {
            throw this.createNoApplicableCodeExceptionWithHttpStatusInternalServerError(ex);
        }
        return new GetStatusResponse(service, version, status);
    }

    public String getOperationName() {
        return WPSConstants.Operations.GetStatus.toString();
    }

    public Set<OperationHandlerKey> getKeys() {
        return Collections.singleton(KEY);
    }

    public boolean isSupported() {
        return true;
    }
}

