/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.service.operator.validation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.n52.iceland.request.operator.ParameterValidator;
import org.n52.janmayen.Chain;
import org.n52.janmayen.stream.MoreCollectors;
import org.n52.javaps.engine.Engine;
import org.n52.javaps.io.bbox.BoundingBoxInputOutputHandler;
import org.n52.javaps.io.literal.LiteralInputOutputHandler;
import org.n52.shetland.ogc.ows.OwsCode;
import org.n52.shetland.ogc.ows.exception.CompositeOwsException;
import org.n52.shetland.ogc.ows.exception.InvalidParameterValueException;
import org.n52.shetland.ogc.ows.exception.MissingParameterValueException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.wps.Format;
import org.n52.shetland.ogc.wps.InputOccurence;
import org.n52.shetland.ogc.wps.OutputDefinition;
import org.n52.shetland.ogc.wps.ResponseMode;
import org.n52.shetland.ogc.wps.data.FormattedProcessData;
import org.n52.shetland.ogc.wps.data.GroupProcessData;
import org.n52.shetland.ogc.wps.data.ProcessData;
import org.n52.shetland.ogc.wps.data.ReferenceProcessData;
import org.n52.shetland.ogc.wps.data.ValueProcessData;
import org.n52.shetland.ogc.wps.description.BoundingBoxInputDescription;
import org.n52.shetland.ogc.wps.description.BoundingBoxOutputDescription;
import org.n52.shetland.ogc.wps.description.ComplexInputDescription;
import org.n52.shetland.ogc.wps.description.ComplexOutputDescription;
import org.n52.shetland.ogc.wps.description.GroupInputDescription;
import org.n52.shetland.ogc.wps.description.GroupOutputDescription;
import org.n52.shetland.ogc.wps.description.LiteralInputDescription;
import org.n52.shetland.ogc.wps.description.LiteralOutputDescription;
import org.n52.shetland.ogc.wps.description.ProcessDescription;
import org.n52.shetland.ogc.wps.description.ProcessInputDescription;
import org.n52.shetland.ogc.wps.description.ProcessInputDescriptionContainer;
import org.n52.shetland.ogc.wps.description.ProcessOutputDescription;
import org.n52.shetland.ogc.wps.description.ProcessOutputDescriptionContainer;
import org.n52.shetland.ogc.wps.request.ExecuteRequest;

public class ExecuteParameterValidator
implements ParameterValidator<ExecuteRequest> {
    private static final String INPUT = "Input";
    private static final String IDENTIFIER = "Identifier";
    private static final String OUTPUT = "Output";
    private static final String VALUE_INVALID = "The value '%s' of the parameter '%s' is invalid: %s";
    private static final String UNSUPPORTED_FORMAT = "unsupported format";
    private final Engine engine;

    @Inject
    public ExecuteParameterValidator(Engine engine) {
        this.engine = engine;
    }

    public void validate(ExecuteRequest request) throws OwsExceptionReport {
        CompositeOwsException exception = new CompositeOwsException();
        if (request.getId() == null) {
            exception.add(new OwsExceptionReport[]{new MissingParameterValueException(IDENTIFIER)});
        } else {
            ProcessDescription description = this.engine.getProcessDescription(request.getId()).orElse(null);
            if (description == null) {
                exception.add(new OwsExceptionReport[]{new InvalidParameterValueException(IDENTIFIER, request.getId().getValue())});
            } else {
                try {
                    this.validate(request, description);
                }
                catch (OwsExceptionReport ex) {
                    exception.add(new OwsExceptionReport[]{ex});
                }
            }
        }
        exception.throwIfNotEmpty();
    }

    private void validate(ExecuteRequest request, ProcessDescription description) throws OwsExceptionReport {
        CompositeOwsException exception = new CompositeOwsException();
        if (request.getResponseMode() == ResponseMode.RAW && (request.getOutputs().size() > 1 || request.getOutputs().isEmpty() && description.getOutputs().size() > 1)) {
            exception.add(new OwsExceptionReport[]{new InvalidParameterValueException().at("responseMode").withMessage("The value 'raw' of the parameter 'responseMode' is invalid. Single output is required.", new Object[0])});
        }
        try {
            this.validateInputs(request.getInputs(), (ProcessInputDescriptionContainer)description);
        }
        catch (OwsExceptionReport ex) {
            exception.add(new OwsExceptionReport[]{ex});
        }
        try {
            this.validateOutputs(request.getOutputs(), (ProcessOutputDescriptionContainer)description);
        }
        catch (OwsExceptionReport ex) {
            exception.add(new OwsExceptionReport[]{ex});
        }
        try {
            this.validateCardinalities(request.getInputs(), description);
        }
        catch (OwsExceptionReport ex) {
            exception.add(new OwsExceptionReport[]{ex});
        }
        exception.throwIfNotEmpty();
    }

    private void validateCardinalities(List<ProcessData> inputs, ProcessDescription description) throws OwsExceptionReport {
        CompositeOwsException exception = new CompositeOwsException();
        InputOccurenceCollector collector = new InputOccurenceCollector();
        Map cardinalities = (Map)inputs.stream().collect(MoreCollectors.toCardinalities(ProcessData::getId, ProcessData::isGroup, x -> x.asGroup().stream()));
        Map occurences = description.getInputDescriptions().stream().map(input -> (Map)input.visit((ProcessInputDescription.ReturningVisitor)collector)).collect(HashMap::new, Map::putAll, Map::putAll);
        cardinalities.forEach((chain, cardinality) -> Optional.ofNullable(occurences.get(chain)).filter(occurence -> !occurence.isInBounds(cardinality)).ifPresent(occurence -> exception.add(new OwsExceptionReport[]{new InvalidParameterValueException().at(INPUT).withMessage("The input %s has an invalid cardinality of %s; should be in %s.", new Object[]{chain.toString(), cardinality, occurence})})));
        occurences.forEach((chain, occurence) -> {
            if (occurence.isRequired() && !cardinalities.containsKey(chain)) {
                exception.add(new OwsExceptionReport[]{new MissingParameterValueException().at(INPUT).withMessage("The input %s is required", new Object[]{chain.toString()})});
            }
        });
        exception.throwIfNotEmpty();
    }

    private void validateInputs(List<ProcessData> inputs, ProcessInputDescriptionContainer descriptions) throws OwsExceptionReport {
        CompositeOwsException exception = new CompositeOwsException();
        inputs.stream().forEach(input -> {
            try {
                this.validateInput((ProcessData)input, descriptions);
            }
            catch (OwsExceptionReport ex) {
                exception.add(new OwsExceptionReport[]{ex});
            }
        });
        exception.throwIfNotEmpty();
    }

    private void validateOutputs(Collection<OutputDefinition> outputs, ProcessOutputDescriptionContainer processDescription) throws OwsExceptionReport {
        CompositeOwsException exception = new CompositeOwsException();
        ((Stream)outputs.stream().map(OutputDefinition::getId).collect(MoreCollectors.toDuplicateStream())).map(ExecuteParameterValidator::duplicateOutput).forEach(xva$0 -> exception.add(new OwsExceptionReport[]{xva$0}));
        for (OutputDefinition output : outputs) {
            ProcessOutputDescription description = processDescription.getOutput(output.getId());
            if (description == null) {
                exception.add(new OwsExceptionReport[]{ExecuteParameterValidator.invalidOutput(output, "no output with the specified identifier")});
                continue;
            }
            if (output.hasOutputs()) {
                if (description.isGroup()) {
                    try {
                        this.validateOutputs(output.getOutputs(), (ProcessOutputDescriptionContainer)description.asGroup());
                    }
                    catch (OwsExceptionReport ex) {
                        exception.add(new OwsExceptionReport[]{ex});
                    }
                    continue;
                }
                exception.add(new OwsExceptionReport[]{ExecuteParameterValidator.invalidOutput(output, "output does not allow nested inputs")});
                continue;
            }
            try {
                if (output.getFormat().isEmpty()) continue;
                description.visit((ProcessOutputDescription.ThrowingVisitor)new OutputFormatValidator(output));
            }
            catch (OwsExceptionReport ex) {
                exception.add(new OwsExceptionReport[]{ex});
            }
        }
        exception.throwIfNotEmpty();
    }

    private void validateFormat(FormattedProcessData input, ProcessInputDescription inputDescription) throws OwsExceptionReport {
        if (!input.getFormat().isEmpty()) {
            inputDescription.visit((ProcessInputDescription.ThrowingVisitor)new InputFormatValidator(input));
        }
    }

    private void validateInput(ReferenceProcessData input, ProcessInputDescription inputDescription) throws OwsExceptionReport {
        CompositeOwsException exception = new CompositeOwsException();
        if (input.getURI() == null) {
            exception.add(new OwsExceptionReport[]{ExecuteParameterValidator.invalidInput((ProcessData)input, "missing input reference uri")});
        }
        try {
            this.validateFormat((FormattedProcessData)input, inputDescription);
        }
        catch (OwsExceptionReport ex) {
            exception.add(new OwsExceptionReport[]{ex});
        }
        exception.throwIfNotEmpty();
    }

    private void validateInput(ValueProcessData input, ProcessInputDescription inputDescription) throws OwsExceptionReport {
        this.validateFormat((FormattedProcessData)input, inputDescription);
    }

    private void validateInput(GroupProcessData input, ProcessInputDescription inputDescription) throws OwsExceptionReport {
        CompositeOwsException exception = new CompositeOwsException();
        if (!inputDescription.isGroup()) {
            exception.add(new OwsExceptionReport[]{ExecuteParameterValidator.invalidInput((ProcessData)input, "input does not allow nested inputs")});
        } else {
            try {
                this.validateInputs(input.getElements(), (ProcessInputDescriptionContainer)inputDescription.asGroup());
            }
            catch (OwsExceptionReport ex) {
                exception.add(new OwsExceptionReport[]{ex});
            }
        }
        exception.throwIfNotEmpty();
    }

    private void validateInput(ProcessData input, ProcessInputDescriptionContainer descriptions) throws OwsExceptionReport {
        ProcessInputDescription description = descriptions.getInput(input.getId());
        if (description == null) {
            throw ExecuteParameterValidator.invalidInput(input, "no input with the specified identifier");
        }
        if (input.isGroup()) {
            this.validateInput(input.asGroup(), description);
        } else if (input.isReference()) {
            this.validateInput(input.asReference(), description);
        } else if (input.isValue()) {
            this.validateInput(input.asValue(), description);
        }
    }

    private static OwsExceptionReport invalidInput(ProcessData input, String messageDetail) {
        String id = input.getId().getValue();
        return new InvalidParameterValueException().at(INPUT).withMessage(VALUE_INVALID, new Object[]{id, INPUT, messageDetail});
    }

    private static OwsExceptionReport invalidOutput(OutputDefinition output, String messageDetail) {
        String id = output.getId().getValue();
        return new InvalidParameterValueException().at(OUTPUT).withMessage(VALUE_INVALID, new Object[]{id, OUTPUT, messageDetail});
    }

    private static OwsExceptionReport duplicateOutput(OwsCode id) {
        return new InvalidParameterValueException().at(OUTPUT).withMessage("Duplicate output definition for output %s", new Object[]{id});
    }

    private static class InputOccurenceCollector
    implements ProcessInputDescription.ReturningVisitor<Map<Chain<OwsCode>, InputOccurence>> {
        private final Optional<Chain<OwsCode>> parent;

        InputOccurenceCollector(Chain<OwsCode> parent) {
            this.parent = Optional.ofNullable(parent);
        }

        InputOccurenceCollector() {
            this(null);
        }

        public Map<Chain<OwsCode>, InputOccurence> visit(BoundingBoxInputDescription input) {
            return this.visitNonGroup((ProcessInputDescription)input);
        }

        public Map<Chain<OwsCode>, InputOccurence> visit(ComplexInputDescription input) {
            return this.visitNonGroup((ProcessInputDescription)input);
        }

        public Map<Chain<OwsCode>, InputOccurence> visit(LiteralInputDescription input) {
            return this.visitNonGroup((ProcessInputDescription)input);
        }

        public Map<Chain<OwsCode>, InputOccurence> visit(GroupInputDescription input) {
            Chain<OwsCode> chain = this.getChain((ProcessInputDescription)input);
            HashMap<Chain<OwsCode>, InputOccurence> occurences = new HashMap<Chain<OwsCode>, InputOccurence>(input.getInputs().size() + 1);
            occurences.put(chain, input.getOccurence());
            InputOccurenceCollector collector = new InputOccurenceCollector(chain);
            input.getInputDescriptions().stream().map(sub -> (Map)sub.visit((ProcessInputDescription.ReturningVisitor)collector)).forEach(occurences::putAll);
            return occurences;
        }

        private Chain<OwsCode> getChain(ProcessInputDescription input) {
            return this.parent.map(c -> c.child((Object)input.getId())).orElseGet(() -> new Chain((Object)input.getId()));
        }

        private Map<Chain<OwsCode>, InputOccurence> visitNonGroup(ProcessInputDescription input) {
            return Collections.singletonMap(this.getChain(input), input.getOccurence());
        }
    }

    private static class InputFormatValidator
    implements ProcessInputDescription.ThrowingVisitor<OwsExceptionReport> {
        private final FormattedProcessData input;

        InputFormatValidator(FormattedProcessData input) {
            this.input = Objects.requireNonNull(input);
        }

        public void visit(BoundingBoxInputDescription description) throws OwsExceptionReport {
            this.checkCompatibility(BoundingBoxInputOutputHandler.FORMATS.stream());
        }

        public void visit(ComplexInputDescription description) throws OwsExceptionReport {
            this.checkCompatibility(Stream.concat(Stream.of(description.getDefaultFormat()), description.getSupportedFormats().stream()));
        }

        public void visit(LiteralInputDescription description) throws OwsExceptionReport {
            this.checkCompatibility(LiteralInputOutputHandler.FORMATS.stream());
        }

        public void visit(GroupInputDescription description) throws OwsExceptionReport {
            throw this.unsupportedFormat();
        }

        private OwsExceptionReport unsupportedFormat() {
            return ExecuteParameterValidator.invalidInput((ProcessData)this.input, ExecuteParameterValidator.UNSUPPORTED_FORMAT);
        }

        private void checkCompatibility(Stream<Format> formats) throws OwsExceptionReport {
            if (!formats.anyMatch(f -> f.isCompatible(this.input.getFormat()))) {
                throw this.unsupportedFormat();
            }
        }
    }

    private static class OutputFormatValidator
    implements ProcessOutputDescription.ThrowingVisitor<OwsExceptionReport> {
        private final OutputDefinition output;

        OutputFormatValidator(OutputDefinition output) {
            this.output = Objects.requireNonNull(output);
        }

        public void visit(BoundingBoxOutputDescription description) throws OwsExceptionReport {
            this.checkCompatibility(BoundingBoxInputOutputHandler.FORMATS.stream());
        }

        public void visit(ComplexOutputDescription description) throws OwsExceptionReport {
            this.checkCompatibility(Stream.concat(Stream.of(description.getDefaultFormat()), description.getSupportedFormats().stream()));
        }

        public void visit(LiteralOutputDescription description) throws OwsExceptionReport {
            this.checkCompatibility(LiteralInputOutputHandler.FORMATS.stream());
        }

        public void visit(GroupOutputDescription output) throws OwsExceptionReport {
            throw this.unsupportedFormat();
        }

        private OwsExceptionReport unsupportedFormat() {
            return ExecuteParameterValidator.invalidOutput(this.output, ExecuteParameterValidator.UNSUPPORTED_FORMAT);
        }

        private void checkCompatibility(Stream<Format> formats) throws OwsExceptionReport {
            if (!formats.anyMatch(f -> f.isCompatible(this.output.getFormat()))) {
                throw this.unsupportedFormat();
            }
        }
    }
}

