/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.service.handler;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.inject.Inject;
import org.n52.iceland.request.handler.GenericOperationHandler;
import org.n52.iceland.request.handler.OperationHandlerKey;
import org.n52.janmayen.http.MediaType;
import org.n52.javaps.engine.Engine;
import org.n52.javaps.engine.EngineException;
import org.n52.javaps.engine.JobNotFoundException;
import org.n52.javaps.service.handler.AbstractJobHandler;
import org.n52.shetland.ogc.ows.exception.InvalidParameterValueException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.wps.JobId;
import org.n52.shetland.ogc.wps.ResponseMode;
import org.n52.shetland.ogc.wps.Result;
import org.n52.shetland.ogc.wps.WPSConstants;
import org.n52.shetland.ogc.wps.request.GetResultRequest;
import org.n52.shetland.ogc.wps.response.GetResultResponse;

public class GetResultHandler
extends AbstractJobHandler
implements GenericOperationHandler<GetResultRequest, GetResultResponse> {
    private static final OperationHandlerKey KEY = new OperationHandlerKey("WPS", (Enum)WPSConstants.Operations.GetResult);

    @Inject
    public GetResultHandler(Engine engine) {
        super(engine, true);
    }

    public GetResultResponse handle(GetResultRequest request) throws OwsExceptionReport {
        String service = request.getService();
        String version = request.getVersion();
        JobId jobId = request.getJobId();
        try {
            Future result = this.getEngine().getResult(jobId);
            GetResultResponse response = new GetResultResponse(service, version, (Result)result.get());
            if (response.getResult().getResponseMode() == ResponseMode.RAW) {
                response.setContentType(new MediaType());
            }
            return response;
        }
        catch (JobNotFoundException ex) {
            throw new InvalidParameterValueException("JobId", jobId.getValue()).causedBy((Throwable)ex);
        }
        catch (InterruptedException | EngineException ex) {
            throw this.createNoApplicableCodeExceptionWithHttpStatusInternalServerError(ex);
        }
        catch (ExecutionException ex) {
            throw this.createNoApplicableCodeExceptionWithHttpStatusInternalServerError(ex.getCause());
        }
    }

    public String getOperationName() {
        return WPSConstants.Operations.GetResult.toString();
    }

    public Set<OperationHandlerKey> getKeys() {
        return Collections.singleton(KEY);
    }

    public boolean isSupported() {
        return true;
    }
}

