/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.service.operator.validation;

import org.n52.javaps.engine.EngineException;
import org.n52.javaps.service.operator.validation.EngineParameterValidator;
import org.n52.shetland.ogc.ows.exception.MissingParameterValueException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.wps.JobId;
import org.n52.shetland.ogc.wps.exception.NoSuchJobException;
import org.n52.shetland.ogc.wps.exception.ResultNotReadyException;
import org.n52.shetland.ogc.wps.request.AbstractJobIdRequest;
import org.n52.shetland.ogc.wps.request.GetResultRequest;

public class JobIdParameterValidator
extends EngineParameterValidator<AbstractJobIdRequest> {
    private static final String JOB_ID = "JobId";

    public void validate(AbstractJobIdRequest request) throws OwsExceptionReport {
        JobId jobId = request.getJobId();
        if (jobId == null || jobId.getValue() == null || jobId.getValue().isEmpty()) {
            throw new MissingParameterValueException(JOB_ID);
        }
        if (!this.getEngine().hasJob(jobId)) {
            throw new NoSuchJobException(JOB_ID, jobId.getValue());
        }
        boolean resultReady = false;
        try {
            resultReady = this.getEngine().getResult(jobId).isDone();
        }
        catch (EngineException engineException) {
            // empty catch block
        }
        if (!resultReady && request instanceof GetResultRequest) {
            throw new ResultNotReadyException(JOB_ID, jobId.getValue());
        }
    }
}

