/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.service.reference;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.n52.janmayen.http.MediaType;
import org.n52.janmayen.http.MediaTypes;
import org.n52.javaps.engine.EngineException;
import org.n52.javaps.engine.JobNotFoundException;
import org.n52.javaps.engine.OutputNotFoundException;
import org.n52.javaps.engine.OutputReference;
import org.n52.javaps.engine.OutputReferencer;
import org.n52.javaps.engine.ResultPersistence;
import org.n52.javaps.service.InternalServerErrorException;
import org.n52.javaps.service.NotFoundException;
import org.n52.shetland.ogc.wps.Format;
import org.n52.shetland.ogc.wps.data.ProcessData;
import org.n52.shetland.ogc.wps.data.ValueProcessData;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.stream.MissingStreamWriterException;
import org.n52.svalbard.encode.stream.StreamWriter;
import org.n52.svalbard.encode.stream.StreamWriterKey;
import org.n52.svalbard.encode.stream.StreamWriterRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@RequestMapping(value={"/results/{jobId}/**"})
public class OutputReferenceEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(OutputReferenceEndpoint.class);
    private final OutputReferencer outputReferencer;
    private final ResultPersistence resultManager;
    private final StreamWriterRepository streamWriterRepository;

    @Inject
    public OutputReferenceEndpoint(OutputReferencer outputReferencer, ResultPersistence resultManager, StreamWriterRepository streamWriterRepository) {
        this.outputReferencer = Objects.requireNonNull(outputReferencer);
        this.resultManager = Objects.requireNonNull(resultManager);
        this.streamWriterRepository = Objects.requireNonNull(streamWriterRepository);
    }

    @RequestMapping(method={RequestMethod.GET})
    public void get(@PathVariable String jobId, HttpServletRequest request, HttpServletResponse response) throws NotFoundException, InternalServerErrorException {
        OutputReference reference = this.toOutputReference(request);
        LOG.info("Getting output {}", (Object)reference);
        ProcessData output = this.getOutput(reference);
        if (output.isGroup() || output.isReference()) {
            this.writeWrapper(output, response);
        } else if (output.isValue()) {
            this.writeRawValue(output, response);
        }
    }

    private void writeWrapper(ProcessData output, HttpServletResponse response) throws InternalServerErrorException {
        try {
            MediaType mediaType = MediaTypes.APPLICATION_XML;
            StreamWriter<ProcessData> writer = this.getWriter(output, mediaType);
            response.setHeader("Content-Type", mediaType.toString());
            writer.write((Object)output, (OutputStream)response.getOutputStream());
        }
        catch (IOException | EncodingException ex) {
            throw new InternalServerErrorException(ex);
        }
    }

    private void writeRawValue(ProcessData output, HttpServletResponse response) throws InternalServerErrorException {
        ValueProcessData valueOutput = output.asValue();
        Format format = valueOutput.getFormat();
        format.getMimeType().ifPresent(mimeType -> response.setHeader("Content-Type", mimeType));
        format.getEncoding().ifPresent(encoding -> response.setHeader("Content-Encoding", encoding));
        try (InputStream stream = valueOutput.getData();){
            ByteStreams.copy((InputStream)stream, (OutputStream)response.getOutputStream());
        }
        catch (IOException ex) {
            throw new InternalServerErrorException(ex);
        }
    }

    private OutputReference toOutputReference(HttpServletRequest request) {
        URI toUri = UriComponentsBuilder.fromUriString((String)request.getRequestURI()).build().toUri();
        return this.outputReferencer.dereference(toUri);
    }

    private <T> StreamWriter<? super T> getWriter(T output, MediaType mediaType) throws InternalServerErrorException {
        StreamWriterKey key = new StreamWriterKey(output.getClass(), mediaType);
        return (StreamWriter)this.streamWriterRepository.getWriter(key).orElseThrow(() -> new InternalServerErrorException((Throwable)new MissingStreamWriterException(key)));
    }

    private ProcessData getOutput(OutputReference reference) throws InternalServerErrorException, NotFoundException {
        try {
            return this.resultManager.getOutput(reference);
        }
        catch (JobNotFoundException | OutputNotFoundException ex) {
            throw new NotFoundException();
        }
        catch (EngineException ex) {
            throw new InternalServerErrorException(ex);
        }
    }
}

