/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.transactional.rest;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.util.Objects;
import org.n52.faroe.ConfigurationError;
import org.n52.faroe.Validation;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;
import org.n52.janmayen.lifecycle.Constructable;
import org.n52.javaps.engine.ProcessNotFoundException;
import org.n52.javaps.transactional.DuplicateProcessException;
import org.n52.javaps.transactional.TransactionalAlgorithmRegistry;
import org.n52.javaps.transactional.UndeletableProcessException;
import org.n52.javaps.transactional.UnsupportedProcessException;
import org.n52.javaps.transactional.rest.TransactionalApi;
import org.n52.shetland.ogc.ows.OwsCode;
import org.n52.shetland.ogc.wps.ap.ApplicationPackage;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.DecoderRepository;
import org.n52.svalbard.decode.JsonDecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;

@Controller
@Configurable
public class TransactionalApiImpl
implements TransactionalApi,
Constructable {
    private DecoderRepository decoderRepository;
    private Decoder<ApplicationPackage, JsonNode> decoder;
    private String serviceURL;
    private TransactionalAlgorithmRegistry registration;

    @Autowired
    public void setRegistration(TransactionalAlgorithmRegistry registration) {
        this.registration = Objects.requireNonNull(registration);
    }

    @Autowired
    public void setDecoderRepository(DecoderRepository decoderRepository) {
        this.decoderRepository = Objects.requireNonNull(decoderRepository);
    }

    @Setting(value="service.serviceURL")
    public void setServiceURL(URI serviceURL) {
        Validation.notNull((String)"serviceURL", (Object)serviceURL);
        String url = serviceURL.toString();
        if (url.contains("?")) {
            url = url.split("[?]")[0];
        }
        this.serviceURL = url.replace("/service", "/rest/processes");
    }

    @Override
    public void undeployProcess(String id) throws ProcessNotFoundException, UndeletableProcessException {
        this.registration.unregister(id);
    }

    @Override
    public ResponseEntity<?> deployProcess(JsonNode request) throws DuplicateProcessException, UnsupportedProcessException {
        return ResponseEntity.created((URI)this.getProcessURL(this.registration.register(this.decode(request)))).build();
    }

    @Override
    public void updateProcess(String id, JsonNode request) throws ProcessNotFoundException, UnsupportedProcessException, UndeletableProcessException {
        OwsCode processIdFromPath = new OwsCode(id);
        ApplicationPackage applicationPackage = this.decode(request);
        OwsCode processId = applicationPackage.getProcessDescription().getProcessDescription().getId();
        if (!processId.equals((Object)processIdFromPath)) {
            throw new UnsupportedProcessException(String.format("mismatching process identifiers %s vs. %s", processIdFromPath.getValue(), processId.getValue()));
        }
        this.registration.update(applicationPackage);
    }

    private ApplicationPackage decode(JsonNode request) throws UnsupportedProcessException {
        try {
            return (ApplicationPackage)this.decoder.decode((Object)request);
        }
        catch (DecodingException e) {
            throw new UnsupportedProcessException((Throwable)e);
        }
    }

    private URI getProcessURL(OwsCode id) {
        return URI.create(String.format("%s/%s", this.serviceURL, id.getValue()));
    }

    public void init() {
        this.decoder = (Decoder)this.decoderRepository.tryGetDecoder((DecoderKey)new JsonDecoderKey(ApplicationPackage.class), new DecoderKey[0]).orElseThrow(() -> new ConfigurationError("No application package decoder found", new Object[0]));
    }
}

