/*
 * Decompiled with CFR 0.152.
 */
package org.n52.javaps.transactional.rest;

import org.n52.javaps.rest.EngineExceptionAdvice;
import org.n52.javaps.rest.model.Exception;
import org.n52.javaps.rest.serializer.ExceptionSerializer;
import org.n52.javaps.transactional.DuplicateProcessException;
import org.n52.javaps.transactional.UndeletableProcessException;
import org.n52.javaps.transactional.UnsupportedProcessException;
import org.n52.javaps.transactional.rest.TransactionalApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice(assignableTypes={TransactionalApi.class})
@RequestMapping(produces={"application/json"})
public class TransactionalEngineExceptionAdvice
extends EngineExceptionAdvice {
    @Autowired
    public TransactionalEngineExceptionAdvice(ExceptionSerializer serializer) {
        super(serializer);
    }

    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ExceptionHandler(value={DuplicateProcessException.class})
    public Exception handle(DuplicateProcessException ex) {
        return this.getExceptionSerializer().serializeException("InvalidParameter", ex.getMessage());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={UnsupportedProcessException.class})
    public Exception handle(UnsupportedProcessException ex) {
        return this.getExceptionSerializer().serializeException("InvalidParameter", ex.getMessage());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={UndeletableProcessException.class})
    public Exception handle(UndeletableProcessException ex) {
        return this.getExceptionSerializer().serializeException("InvalidParameter", ex.getMessage());
    }
}

